/************************************************************************************************/
/* Stata User File for H12 Data                                                                 */
/*                                                                                              */
/* This file contains information and a sample Stata program to create a permanent              */
/* Stata dataset for users who want to use Stata in processing the MEPS data provided           */
/* in this PUF release.  Stata (StataCorp) has the capability to produce                        */
/* appropriate standard errors for estimates from a survey with a complex sample                */
/* design such as the Medical Expenditure Panel Survey (MEPS).                                  */
/* The input file for creating a permanent Stata dataset is the ASCII data file                 */
/* (H12.DAT) supplied in this PUF release, which in turn can be extracted from the              */
/* .EXE file. After entering the Stata interactive environment access the Stata DO-File         */
/* editor by clicking on the appropriate icon in the command line at the top of the             */
/* screen.  Copy and paste the following Stata commands into the editor and save as a           */
/* DO file.  A DO file is a Stata program which may then be executed using the DO command.      */
/* For example, if the DO file is named H12.DO and is located in the directory                  */
/* C:\MEPS\PROG, then the file may be executed by typing the following command into             */
/* the Stata command line:                                                                      */
/*                         do C:\MEPS\PROG\H12.DO                                               */
/* The program below will output the Stata dataset H12.DTA                                      */
/************************************************************************************************/


#delimit ;
cd $datadir/MEPS/dat/fullyearconsolidated;
clear;

* INPUT ALL VARIABLES;
infix
  long   DUID 1-5
  int    PID 6-8
  str    DUPERSID 9-16
  str    FAMID1 17-18
  str    FAMID2 19-20
  str    FAMID96 21-22
  str    FAMIDYR 23-24
  str    CPSFAMID 25-26
  str    RULETTR1 27-28
  str    RULETTR2 29-30
  str    RULETR96 31-32
  byte   RUSIZE1 33-34
  byte   RUSIZE2 35-36
  byte   RUSIZE96 37-38
  byte   RUCLASS1 39-40
  byte   RUCLASS2 41-42
  byte   RUCLAS96 43-44
  byte   FAMSIZE1 45-46
  byte   FAMSIZE2 47-48
  byte   FAMSZE96 49-50
  byte   FMRS1231 51-52
  byte   FAMS1231 53-54
  byte   FAMSZEYR 55-56
  byte   FAMRFPYR 57-57
  byte   FCSZ1231 58-59
  byte   FCRP1231 60-61
  byte   INRU1231 62-62
  byte   INSC1231 63-63
  byte   REGION1 64-65
  byte   REGION2 66-67
  byte   REGION3 68-69
  byte   REGION96 70-71
  byte   MSA3 72-73
  byte   MSA96 74-75
  int    REFPERS1 76-78
  int    REFPERS2 79-81
  int    REFPRS96 82-84
  byte   RESP1 85-86
  byte   RESP2 87-88
  byte   RESP96 89-90
  byte   PROXY1 91-92
  byte   PROXY2 93-94
  byte   PROXY96 95-96
  byte   BEGREFD1 97-98
  byte   BEGREFM1 99-100
  int    BEGREFY1 101-104
  byte   ENDREFD1 105-106
  byte   ENDREFM1 107-108
  int    ENDREFY1 109-112
  byte   BEGREFD2 113-114
  byte   BEGREFM2 115-116
  int    BEGREFY2 117-120
  byte   ENDREFD2 121-122
  byte   ENDREFM2 123-124
  int    ENDREFY2 125-128
  byte   BEGREFD3 129-130
  byte   BEGREFM3 131-132
  int    BEGREFY3 133-136
  byte   ENDRFD96 137-138
  byte   ENDRFM96 139-140
  int    ENDRFY96 141-144
  byte   KEYNESS 145-145
  byte   INSCOPE1 146-146
  byte   INSCOPE2 147-147
  byte   INSCOP96 148-148
  byte   INSCOPE 149-149
  byte   ELIGRND1 150-150
  byte   ELIGRND2 151-151
  byte   ELGRND96 152-152
  byte   ELIGIBLE 153-153
  byte   PSTATUS1 154-155
  byte   PSTATUS2 156-157
  byte   PSTATUS3 158-159
  str    RURSLT1 160-161
  str    RURSLT2 162-163
  str    RURSLT3 164-165
  byte   AGE1X 166-167
  byte   AGE2X 168-169
  byte   AGE96X 170-171
  byte   DOBMM 172-173
  int    DOBYY 174-177
  byte   SEX 178-178
  byte   RACEX 179-180
  byte   RACETHNX 181-181
  byte   HISPANX 182-182
  byte   HISPCAT 183-184
  byte   MARRY1X 185-186
  byte   MARRY2X 187-188
  byte   MARRY96X 189-190
  int    SPOUSID1 191-193
  int    SPOUSID2 194-196
  int    SPOUID96 197-199
  byte   SPOUSIN1 200-201
  byte   SPOUSIN2 202-203
  byte   SPOUIN96 204-205
  byte   EDUCYR1 206-207
  byte   EDUCYR2 208-209
  byte   EDUCYR96 210-211
  byte   HIGHDEG1 212-213
  byte   HIGHDEG2 214-215
  byte   HIDEG96 216-217
  byte   FTSTUD1X 218-219
  byte   FTSTUD2X 220-221
  byte   FTSTU96X 222-223
  byte   ACTDUTY1 224-225
  byte   ACTDUTY2 226-227
  byte   DIDSERVE 228-229
  byte   VETPVIET 230-231
  byte   VETVIET 232-233
  byte   VETKOR 234-235
  byte   VETWW 236-237
  byte   VETOTH 238-239
  byte   REFREL1X 240-241
  byte   REFREL2X 242-243
  byte   RFREL96X 244-245
  int    MOMPID1X 246-248
  int    DADPID1X 249-251
  int    MOMPID2X 252-254
  int    DADPID2X 255-257
  byte   SSIDISAB 258-259
  byte   AFDC 260-261
  byte   FILEDITR 262-263
  byte   WILLFILE 264-265
  byte   FILESTAT 266-267
  byte   FILER 268-269
  byte   JNTINRU 270-271
  int    JOINTPID 272-274
  byte   CLAIMDEP 275-276
  byte   DEPENDNT 277-278
  byte   DEPINRU 279-280
  byte   DEPOUTSD 281-282
  byte   TAXFORM 283-284
  byte   DEDUCTNS 285-286
  byte   ITMEDEXP 287-288
  double MDEXPAMT 289-296
  double NETMDDED 297-304
  double TOTDED 305-312
  byte   CLMHIP 313-314
  byte   ELDISCR 315-316
  byte   EICREDIT 317-318
  int    UNEMTAX 319-321
  int    INTRTAX 322-324
  int    SSECTAX 325-327
  int    IRASTAX 328-330
  byte   FOODSTMP 331-332
  byte   FOODMNTH 333-334
  double FOODCOST 335-340
  double FOODVALU 341-346
  double TTLPNX 347-355
  byte   POVCAT 356-356
  double WAGEPNX 357-365
  byte   WAGEIMP 366-366
  double BUSNPNX 367-375
  byte   BUSNIMP 376-376
  double FARMPNX 377-385
  byte   FARMIMP 386-386
  double INTRPNX 387-394
  byte   INTRIMP 395-395
  double DIVDPNX 396-403
  byte   DIVDIMP 404-404
  double ALIMPNX 405-412
  byte   ALIMIMP 413-413
  double TRSTPNX 414-422
  byte   TRSTIMP 423-423
  double PENSPNX 424-431
  byte   PENSIMP 432-432
  double IRASPNX 433-440
  byte   IRASIMP 441-441
  double SSECPNX 442-449
  byte   SSECIMP 450-450
  double UNEMPNX 451-457
  byte   UNEMIMP 458-458
  double WCMPPNX 459-466
  byte   WCMPIMP 467-467
  double VETSPNX 468-475
  byte   VETSIMP 476-476
  double CASHPNX 477-484
  byte   CASHIMP 485-485
  double OTHRPNX 486-493
  byte   OTHRIMP 494-494
  double CHLDPNX 495-502
  byte   CHLDIMP 503-503
  double PUBPNX 504-511
  byte   PUBIMP 512-512
  double SSIPNX 513-520
  byte   SSIIMP 521-521
  double SALEPNX 522-530
  byte   SALEIMP 531-531
  double REFDPNX 532-538
  byte   REFDIMP 539-539
  byte   EMPST1 540-541
  byte   EMPST2 542-543
  byte   EMPST96 544-545
  byte   NWK1 546-547
  byte   NWK2 548-549
  byte   NWK96 550-551
  byte   SELFCM1 552-553
  byte   SELFCM2 554-555
  byte   SELFCM96 556-557
  byte   PAYDR1 558-559
  byte   PAYDR2 560-561
  byte   PAYDR96 562-563
  byte   SICPAY1 564-565
  byte   SICPAY2 566-567
  byte   SICPAY96 568-569
  byte   PAYVAC1 570-571
  byte   PAYVAC2 572-573
  byte   PAYVAC96 574-575
  byte   RETPLN1 576-577
  byte   RETPLN2 578-579
  byte   RETPLN96 580-581
  byte   MORE1 582-583
  byte   MORE2 584-585
  byte   MORE96 586-587
  byte   JOBORG1 588-589
  byte   JOBORG2 590-591
  byte   JOBORG96 592-593
  byte   BSNTY1 594-595
  byte   BSNTY2 596-597
  byte   BSNTY96 598-599
  double HRWG1X 600-606
  byte   HRWGIM1 607-607
  byte   HRHOW1 608-609
  double HRWG2X 610-615
  byte   HRWGIM2 616-616
  byte   HRHOW2 617-618
  double HRWG96X 619-624
  byte   HRWGIM96 625-625
  byte   HRHOW96 626-627
  byte   HELD1X 628-629
  byte   HELD2X 630-631
  byte   HELD96X 632-633
  byte   OFFER1X 634-635
  byte   OFFER2X 636-637
  byte   OFFER96X 638-639
  byte   CHOIC1 640-641
  byte   CHOIC2 642-643
  byte   CHOIC96 644-645
  byte   DISVW1X 646-647
  byte   DISVW2X 648-649
  byte   DISVW96X 650-651
  int    HOUR1 652-654
  int    HOUR2 655-657
  int    HOUR96 658-660
  int    NUMEMP1 661-663
  int    NUMEMP2 664-666
  int    NUMEMP96 667-669
  byte   CIND1 670-671
  byte   CIND2 672-673
  byte   CIND96 674-675
  byte   COCCP1 676-677
  byte   COCCP2 678-679
  byte   COCCP96 680-681
  byte   UNION1 682-683
  byte   UNION2 684-685
  byte   UNION96 686-687
  byte   SHFTWK1 688-689
  byte   SHFTWK2 690-691
  byte   SHFTWK96 692-693
  byte   BGNWK1 694-695
  byte   BGNWK2 696-697
  byte   BGNWK96 698-699
  byte   ENDWK1 700-701
  byte   ENDWK2 702-703
  byte   ENDWK96 704-705
  byte   STJBMM1 706-707
  byte   STJBDD1 708-709
  byte   STJBYY1 710-711
  byte   STJBMM2 712-713
  byte   STJBDD2 714-715
  byte   STJBYY2 716-717
  byte   STJBMM96 718-719
  byte   STJBDD96 720-721
  byte   STJBYY96 722-723
  byte   EVRET96 724-725
  byte   EVRWRK 726-727
  byte   MORJOB1 728-729
  byte   MORJOB2 730-731
  byte   MORJOB96 732-733
  byte   CHNGJ12 734-735
  byte   CHNGJ231 736-737
  byte   YCHJB12 738-739
  byte   YCHJB231 740-741
  byte   CHMPNOW1 742-743
  byte   MCAID1 744-745
  byte   MCAID1X 746-747
  byte   OTPUBA1 748-749
  byte   OTPUBB1 750-751
  byte   STATPRG1 752-753
  byte   PUBLIC1 754-755
  byte   OTGOVPY1 756-757
  byte   MCARNOW1 758-759
  byte   MCARNW1X 760-761
  byte   PRIV1 762-763
  byte   PRIVEG1 764-765
  byte   PRIVU1 766-767
  byte   PRIVS1 768-769
  byte   PRIVOG1 770-771
  byte   PRIVNG1 772-773
  byte   PRGVPYA1 774-775
  byte   PRGVPYB1 776-777
  byte   PRIVDK1 778-779
  byte   PRIVOUT1 780-781
  byte   HPRIV1 782-783
  byte   HPRIVEG1 784-785
  byte   HPRIVU1 786-787
  byte   HPRIVS1 788-789
  byte   HPRIVOG1 790-791
  byte   HPRIVNG1 792-793
  byte   HPRIVDK1 794-795
  byte   MCRHMO1 796-797
  byte   UPRHMO1 798-799
  byte   UPRMNC1 800-801
  byte   UPUBHMO1 802-803
  byte   UPUBMNC1 804-805
  byte   INSURED1 806-807
  byte   CHJA96X 808-809
  byte   CHFE96X 810-811
  byte   CHMA96X 812-813
  byte   CHAP96X 814-815
  byte   CHMY96X 816-817
  byte   CHJU96X 818-819
  byte   CHJL96X 820-821
  byte   CHAU96X 822-823
  byte   CHSE96X 824-825
  byte   CHOC96X 826-827
  byte   CHNO96X 828-829
  byte   CHDE96X 830-831
  byte   MCRJA96 832-833
  byte   MCRFE96 834-835
  byte   MCRMA96 836-837
  byte   MCRAP96 838-839
  byte   MCRMY96 840-841
  byte   MCRJU96 842-843
  byte   MCRJL96 844-845
  byte   MCRAU96 846-847
  byte   MCRSE96 848-849
  byte   MCROC96 850-851
  byte   MCRNO96 852-853
  byte   MCRDE96 854-855
  byte   MCRJA96X 856-857
  byte   MCRFE96X 858-859
  byte   MCRMA96X 860-861
  byte   MCRAP96X 862-863
  byte   MCRMY96X 864-865
  byte   MCRJU96X 866-867
  byte   MCRJL96X 868-869
  byte   MCRAU96X 870-871
  byte   MCRSE96X 872-873
  byte   MCROC96X 874-875
  byte   MCRNO96X 876-877
  byte   MCRDE96X 878-879
  byte   MCDJA96 880-881
  byte   MCDFE96 882-883
  byte   MCDMA96 884-885
  byte   MCDAP96 886-887
  byte   MCDMY96 888-889
  byte   MCDJU96 890-891
  byte   MCDJL96 892-893
  byte   MCDAU96 894-895
  byte   MCDSE96 896-897
  byte   MCDOC96 898-899
  byte   MCDNO96 900-901
  byte   MCDDE96 902-903
  byte   MCDJA96X 904-905
  byte   MCDFE96X 906-907
  byte   MCDMA96X 908-909
  byte   MCDAP96X 910-911
  byte   MCDMY96X 912-913
  byte   MCDJU96X 914-915
  byte   MCDJL96X 916-917
  byte   MCDAU96X 918-919
  byte   MCDSE96X 920-921
  byte   MCDOC96X 922-923
  byte   MCDNO96X 924-925
  byte   MCDDE96X 926-927
  byte   OPAJA96 928-929
  byte   OPAFE96 930-931
  byte   OPAMA96 932-933
  byte   OPAAP96 934-935
  byte   OPAMY96 936-937
  byte   OPAJU96 938-939
  byte   OPAJL96 940-941
  byte   OPAAU96 942-943
  byte   OPASE96 944-945
  byte   OPAOC96 946-947
  byte   OPANO96 948-949
  byte   OPADE96 950-951
  byte   OPBJA96 952-953
  byte   OPBFE96 954-955
  byte   OPBMA96 956-957
  byte   OPBAP96 958-959
  byte   OPBMY96 960-961
  byte   OPBJU96 962-963
  byte   OPBJL96 964-965
  byte   OPBAU96 966-967
  byte   OPBSE96 968-969
  byte   OPBOC96 970-971
  byte   OPBNO96 972-973
  byte   OPBDE96 974-975
  byte   STAJA96 976-977
  byte   STAFE96 978-979
  byte   STAMA96 980-981
  byte   STAAP96 982-983
  byte   STAMY96 984-985
  byte   STAJU96 986-987
  byte   STAJL96 988-989
  byte   STAAU96 990-991
  byte   STASE96 992-993
  byte   STAOC96 994-995
  byte   STANO96 996-997
  byte   STADE96 998-999
  byte   PUBJA96X 1000-1001
  byte   PUBFE96X 1002-1003
  byte   PUBMA96X 1004-1005
  byte   PUBAP96X 1006-1007
  byte   PUBMY96X 1008-1009
  byte   PUBJU96X 1010-1011
  byte   PUBJL96X 1012-1013
  byte   PUBAU96X 1014-1015
  byte   PUBSE96X 1016-1017
  byte   PUBOC96X 1018-1019
  byte   PUBNO96X 1020-1021
  byte   PUBDE96X 1022-1023
  byte   PEGJA96 1024-1025
  byte   PEGFE96 1026-1027
  byte   PEGMA96 1028-1029
  byte   PEGAP96 1030-1031
  byte   PEGMY96 1032-1033
  byte   PEGJU96 1034-1035
  byte   PEGJL96 1036-1037
  byte   PEGAU96 1038-1039
  byte   PEGSE96 1040-1041
  byte   PEGOC96 1042-1043
  byte   PEGNO96 1044-1045
  byte   PEGDE96 1046-1047
  byte   PDKJA96 1048-1049
  byte   PDKFE96 1050-1051
  byte   PDKMA96 1052-1053
  byte   PDKAP96 1054-1055
  byte   PDKMY96 1056-1057
  byte   PDKJU96 1058-1059
  byte   PDKJL96 1060-1061
  byte   PDKAU96 1062-1063
  byte   PDKSE96 1064-1065
  byte   PDKOC96 1066-1067
  byte   PDKNO96 1068-1069
  byte   PDKDE96 1070-1071
  byte   PNGJA96 1072-1073
  byte   PNGFE96 1074-1075
  byte   PNGMA96 1076-1077
  byte   PNGAP96 1078-1079
  byte   PNGMY96 1080-1081
  byte   PNGJU96 1082-1083
  byte   PNGJL96 1084-1085
  byte   PNGAU96 1086-1087
  byte   PNGSE96 1088-1089
  byte   PNGOC96 1090-1091
  byte   PNGNO96 1092-1093
  byte   PNGDE96 1094-1095
  byte   POGJA96 1096-1097
  byte   POGFE96 1098-1099
  byte   POGMA96 1100-1101
  byte   POGAP96 1102-1103
  byte   POGMY96 1104-1105
  byte   POGJU96 1106-1107
  byte   POGJL96 1108-1109
  byte   POGAU96 1110-1111
  byte   POGSE96 1112-1113
  byte   POGOC96 1114-1115
  byte   POGNO96 1116-1117
  byte   POGDE96 1118-1119
  byte   PRSJA96 1120-1121
  byte   PRSFE96 1122-1123
  byte   PRSMA96 1124-1125
  byte   PRSAP96 1126-1127
  byte   PRSMY96 1128-1129
  byte   PRSJU96 1130-1131
  byte   PRSJL96 1132-1133
  byte   PRSAU96 1134-1135
  byte   PRSSE96 1136-1137
  byte   PRSOC96 1138-1139
  byte   PRSNO96 1140-1141
  byte   PRSDE96 1142-1143
  byte   POUJA96 1144-1145
  byte   POUFE96 1146-1147
  byte   POUMA96 1148-1149
  byte   POUAP96 1150-1151
  byte   POUMY96 1152-1153
  byte   POUJU96 1154-1155
  byte   POUJL96 1156-1157
  byte   POUAU96 1158-1159
  byte   POUSE96 1160-1161
  byte   POUOC96 1162-1163
  byte   POUNO96 1164-1165
  byte   POUDE96 1166-1167
  byte   PRIJA96 1168-1169
  byte   PRIFE96 1170-1171
  byte   PRIMA96 1172-1173
  byte   PRIAP96 1174-1175
  byte   PRIMY96 1176-1177
  byte   PRIJU96 1178-1179
  byte   PRIJL96 1180-1181
  byte   PRIAU96 1182-1183
  byte   PRISE96 1184-1185
  byte   PRIOC96 1186-1187
  byte   PRINO96 1188-1189
  byte   PRIDE96 1190-1191
  byte   HPEJA96 1192-1193
  byte   HPEFE96 1194-1195
  byte   HPEMA96 1196-1197
  byte   HPEAP96 1198-1199
  byte   HPEMY96 1200-1201
  byte   HPEJU96 1202-1203
  byte   HPEJL96 1204-1205
  byte   HPEAU96 1206-1207
  byte   HPESE96 1208-1209
  byte   HPEOC96 1210-1211
  byte   HPENO96 1212-1213
  byte   HPEDE96 1214-1215
  byte   HPDJA96 1216-1217
  byte   HPDFE96 1218-1219
  byte   HPDMA96 1220-1221
  byte   HPDAP96 1222-1223
  byte   HPDMY96 1224-1225
  byte   HPDJU96 1226-1227
  byte   HPDJL96 1228-1229
  byte   HPDAU96 1230-1231
  byte   HPDSE96 1232-1233
  byte   HPDOC96 1234-1235
  byte   HPDNO96 1236-1237
  byte   HPDDE96 1238-1239
  byte   HPNJA96 1240-1241
  byte   HPNFE96 1242-1243
  byte   HPNMA96 1244-1245
  byte   HPNAP96 1246-1247
  byte   HPNMY96 1248-1249
  byte   HPNJU96 1250-1251
  byte   HPNJL96 1252-1253
  byte   HPNAU96 1254-1255
  byte   HPNSE96 1256-1257
  byte   HPNOC96 1258-1259
  byte   HPNNO96 1260-1261
  byte   HPNDE96 1262-1263
  byte   HPOJA96 1264-1265
  byte   HPOFE96 1266-1267
  byte   HPOMA96 1268-1269
  byte   HPOAP96 1270-1271
  byte   HPOMY96 1272-1273
  byte   HPOJU96 1274-1275
  byte   HPOJL96 1276-1277
  byte   HPOAU96 1278-1279
  byte   HPOSE96 1280-1281
  byte   HPOOC96 1282-1283
  byte   HPONO96 1284-1285
  byte   HPODE96 1286-1287
  byte   HPSJA96 1288-1289
  byte   HPSFE96 1290-1291
  byte   HPSMA96 1292-1293
  byte   HPSAP96 1294-1295
  byte   HPSMY96 1296-1297
  byte   HPSJU96 1298-1299
  byte   HPSJL96 1300-1301
  byte   HPSAU96 1302-1303
  byte   HPSSE96 1304-1305
  byte   HPSOC96 1306-1307
  byte   HPSNO96 1308-1309
  byte   HPSDE96 1310-1311
  byte   HPRJA96 1312-1313
  byte   HPRFE96 1314-1315
  byte   HPRMA96 1316-1317
  byte   HPRAP96 1318-1319
  byte   HPRMY96 1320-1321
  byte   HPRJU96 1322-1323
  byte   HPRJL96 1324-1325
  byte   HPRAU96 1326-1327
  byte   HPRSE96 1328-1329
  byte   HPROC96 1330-1331
  byte   HPRNO96 1332-1333
  byte   HPRDE96 1334-1335
  byte   INSJA96X 1336-1337
  byte   INSFE96X 1338-1339
  byte   INSMA96X 1340-1341
  byte   INSAP96X 1342-1343
  byte   INSMY96X 1344-1345
  byte   INSJU96X 1346-1347
  byte   INSJL96X 1348-1349
  byte   INSAU96X 1350-1351
  byte   INSSE96X 1352-1353
  byte   INSOC96X 1354-1355
  byte   INSNO96X 1356-1357
  byte   INSDE96X 1358-1359
  byte   PRVEVER 1360-1360
  byte   CHPEVER 1361-1361
  byte   MCDEVER 1362-1362
  byte   MCREVER 1363-1363
  byte   OPAEVER 1364-1364
  byte   OPBEVER 1365-1365
  byte   UNINSURD 1366-1366
  byte   INSCOV96 1367-1367
  byte   PREGRD1 1368-1369
  byte   PREGRD2 1370-1371
  byte   PREGRD3 1372-1373
  byte   NOWPREG1 1374-1375
  byte   NOWPREG2 1376-1377
  byte   NOWPREG3 1378-1379
  byte   LIVEBIR1 1380-1381
  byte   LIVEBIR2 1382-1383
  byte   LIVEBIR3 1384-1385
  byte   NUMPRG13 1386-1387
  byte   PREG96 1388-1389
  byte   BIRTH96 1390-1391
  int    DDNOWRK1 1392-1394
  int    DDNOWRK2 1395-1397
  int    DDNOWRK3 1398-1400
  byte   WRKINBD1 1401-1402
  int    WRKINBD2 1403-1405
  int    WRKINBD3 1406-1408
  int    DDNSCHL1 1409-1411
  byte   DDNSCHL2 1412-1413
  byte   DDNSCHL3 1414-1415
  int    SCLINBD1 1416-1418
  byte   SCLINBD2 1419-1420
  byte   SCLINBD3 1421-1422
  int    DDBEDYS1 1423-1425
  int    DDBEDYS2 1426-1428
  int    DDBEDYS3 1429-1431
  byte   OTHRDYS1 1432-1433
  byte   OTHRDYS2 1434-1435
  byte   OTHRDYS3 1436-1437
  int    OTHNMDD1 1438-1440
  byte   OTHNMDD2 1441-1442
  byte   OTHNMDD3 1443-1444
  byte   ACCELIG2 1445-1446
  byte   HAVEUSC2 1447-1448
  byte   YNOUSC2 1449-1450
  byte   NOREAS42 1451-1452
  byte   SELDSIC2 1453-1454
  byte   NEWAREA2 1455-1456
  byte   DKWHRUS2 1457-1458
  byte   USCNOTA2 1459-1460
  byte   PERSLAN2 1461-1462
  byte   DIFFPLA2 1463-1464
  byte   INSRPLA2 1465-1466
  byte   MYSELF2 1467-1468
  byte   CARECOS2 1469-1470
  byte   OTHINSR2 1471-1472
  byte   OTHREA42 1473-1474
  byte   TYPEPLC2 1475-1476
  byte   PROVTYX2 1477-1478
  byte   YGOTOUS2 1479-1480
  byte   NOREAS92 1481-1482
  byte   LIKESUS2 1483-1484
  byte   DKELSEW2 1485-1486
  byte   AFFORD2 1487-1488
  byte   OFFICE2 1489-1490
  byte   AVAILTI2 1491-1492
  byte   CONVENI2 1493-1494
  byte   BSTPLAC2 1495-1496
  byte   INSREAS2 1497-1498
  byte   OTHREA92 1499-1500
  byte   GETTOUS2 1501-1502
  byte   TYPEPER2 1503-1504
  byte   LOCATIO2 1505-1506
  byte   MINORPR2 1507-1508
  byte   PREVENT2 1509-1510
  byte   REFFRLS2 1511-1512
  byte   OFFHOUR2 1513-1514
  byte   APPTWLK2 1515-1516
  byte   APPDIFF2 1517-1518
  byte   WAITTIM2 1519-1520
  byte   PHONEDI2 1521-1522
  byte   PRLISTE2 1523-1524
  byte   TREATMN2 1525-1526
  byte   CONFIDN2 1527-1528
  byte   PROVSTA2 1529-1530
  byte   USCQUAL2 1531-1532
  byte   CHNGUSC2 1533-1534
  byte   YCHNGUS2 1535-1536
  byte   ANYUSC2 1537-1538
  byte   YNOMORE2 1539-1540
  byte   NOCARE2 1541-1542
  byte   HCNEEDS2 1543-1544
  byte   OBTAINH2 1545-1546
  byte   MAINPRO2 1547-1548
  byte   NOOTHPR2 1549-1550
  byte   NOAFFOR2 1551-1552
  byte   INSNOPA2 1553-1554
  byte   PREEXCO2 1555-1556
  byte   INSRQRE2 1557-1558
  byte   REFUSIN2 1559-1560
  byte   DISTANC2 1561-1562
  byte   PUBTRAN2 1563-1564
  byte   EXPENSI2 1565-1566
  byte   HEARPRO2 1567-1568
  byte   LANGBAR2 1569-1570
  byte   INTOBLD2 1571-1572
  byte   INSIDE2 1573-1574
  byte   EQUIPMN2 1575-1576
  byte   OFFWORK2 1577-1578
  byte   DKWHERG2 1579-1580
  byte   REFUSER2 1581-1582
  byte   CHLDCAR2 1583-1584
  byte   NOTIME2 1585-1586
  byte   OTHRPRO2 1587-1588
  byte   RTEHLTH1 1589-1590
  byte   RTEPROX1 1591-1592
  byte   MNTHLTH1 1593-1594
  byte   MNTPROX1 1595-1596
  byte   IADLHLP1 1597-1598
  byte   ADLHELP1 1599-1600
  byte   AIDHELP1 1601-1602
  byte   WALKLIM1 1603-1604
  byte   LIFTDIF1 1605-1606
  byte   STEPDIF1 1607-1608
  byte   WALKDIF1 1609-1610
  byte   MILEDIF1 1611-1612
  byte   STNDDIF1 1613-1614
  byte   BENDDIF1 1615-1616
  byte   RECHDIF1 1617-1618
  byte   FINGRDF1 1619-1620
  byte   ACTLIMT1 1621-1622
  byte   WRKLIMT1 1623-1624
  byte   HSELIMT1 1625-1626
  byte   SCHLIMT1 1627-1628
  byte   UNABLE1 1629-1630
  byte   SOCLIMT1 1631-1632
  byte   COGLIMT1 1633-1634
  byte   HSELIG2 1635-1636
  byte   RTEHLTH2 1637-1638
  byte   RTEPROX2 1639-1640
  byte   MNTHLTH2 1641-1642
  byte   MNTPROX2 1643-1644
  byte   IADLHLP2 1645-1646
  byte   ADLHELP2 1647-1648
  byte   WEARGLA2 1649-1650
  byte   SEEDIF2 1651-1652
  byte   BLIND2 1653-1654
  byte   READNEW2 1655-1656
  byte   RECPEOP2 1657-1658
  byte   VISION2 1659-1660
  byte   HEARAID2 1661-1662
  byte   HEARDIF2 1663-1664
  byte   DEAF2 1665-1666
  byte   HEARMOS2 1667-1668
  byte   HEARSOM2 1669-1670
  byte   HEARING2 1671-1672
  byte   ANYLIM12 1673-1674
  byte   LIMACT2 1675-1676
  byte   PLAYLIM2 1677-1678
  byte   CANTPLA2 1679-1680
  byte   SPECPRO2 1681-1682
  byte   DTPSHOT2 1683-1684
  byte   NUMDTP2 1685-1686
  byte   POLIOSH2 1687-1688
  byte   NUMPOLI2 1689-1690
  byte   MMRSHOT2 1691-1692
  byte   HEPBSHT2 1693-1694
  byte   MOMPROB2 1695-1696
  byte   DADPROB2 1697-1698
  byte   UNHAP2 1699-1700
  byte   SCHLBEH2 1701-1702
  byte   HAVEFUN2 1703-1704
  byte   ADULPRO2 1705-1706
  byte   NERVAFR2 1707-1708
  byte   SIBPROB2 1709-1710
  byte   KIDPROB2 1711-1712
  byte   SPORPRO2 1713-1714
  byte   SCHLPRO2 1715-1716
  byte   HOMEBEH2 1717-1718
  byte   TROUBLE2 1719-1720
  byte   SPECSCH2 1721-1722
  byte   SPECED2 1723-1724
  byte   PROGTXT2 1725-1726
  byte   SPCHTHE2 1727-1728
  byte   PSYCNSL2 1729-1730
  byte   OCUPTHE2 1731-1732
  byte   VOCSVCS2 1733-1734
  byte   TUTOR2 1735-1736
  byte   READINT2 1737-1738
  byte   PHYTHER2 1739-1740
  byte   LIFSKIL2 1741-1742
  byte   FAMCNS2 1743-1744
  byte   RECTHER2 1745-1746
  byte   OTHSVC2 1747-1748
  byte   CANTSCH2 1749-1750
  byte   LMOTACT2 1751-1752
  byte   SPECIFL2 1753-1754
  byte   HEALTHY2 1755-1756
  byte   NTHLTHY2 1757-1758
  byte   GETSICK2 1759-1760
  byte   HIGHTFT2 1761-1762
  byte   HIGHTIN2 1763-1764
  int    WEIGHLB2 1765-1767
  byte   WEIGHOZ2 1768-1769
  byte   CHLDLIM2 1770-1771
  byte   ALTCAR96 1772-1773
  byte   ACUPUN96 1774-1775
  byte   NUTRIT96 1776-1777
  byte   MASSAG96 1778-1779
  byte   HERBAL96 1780-1781
  byte   BIOFDB96 1782-1783
  byte   MEDITA96 1784-1785
  byte   HOMEOT96 1786-1787
  byte   SPIRTU96 1788-1789
  byte   HYPNO96 1790-1791
  byte   TRADIT96 1792-1793
  byte   ALTOTH96 1794-1795
  byte   MASSTH96 1796-1797
  byte   ACUPTH96 1798-1799
  byte   MDTREA96 1800-1801
  byte   NURTRT96 1802-1803
  byte   HOMEOM96 1804-1805
  byte   CHIRO96 1806-1807
  byte   CLERGY96 1808-1809
  byte   HERBTR96 1810-1811
  byte   OTHALT96 1812-1813
  int    ALCRVS96 1814-1816
  byte   ALCRVE96 1817-1818
  byte   ALCRSP96 1819-1820
  byte   DISCAL96 1821-1822
  byte   REFRMD96 1823-1824
  long   ALCREE96 1825-1829
  byte   ALCREX96 1830-1831
  byte   INSALT96 1832-1833
  int    PERCIN96 1834-1836
  int    PALTEX96 1837-1840
  byte   PALTEE96 1841-1842
  byte   DENTCHK3 1843-1844
  byte   BLDPCHK3 1845-1846
  byte   CHOLCHK3 1847-1848
  byte   PHYSICL3 1849-1850
  byte   FLUSHOT3 1851-1852
  byte   WEARDEN3 1853-1854
  byte   LOSTEET3 1855-1856
  byte   PROSEXA3 1857-1858
  byte   PAPSMER3 1859-1860
  byte   BRSTEXA3 1861-1862
  byte   MAMOGRM3 1863-1864
  long   TOTTCH96 1865-1870
  long   TOTEXP96 1871-1876
  long   TOTSLF96 1877-1881
  long   TOTMCR96 1882-1887
  long   TOTMCD96 1888-1893
  long   TOTPRV96 1894-1899
  long   TOTVA96 1900-1905
  int    TOTCHM96 1906-1909
  long   TOTOFD96 1910-1914
  int    TOTSTL96 1915-1918
  long   TOTWCP96 1919-1923
  long   TOTOPR96 1924-1928
  long   TOTOPU96 1929-1933
  long   TOTOSR96 1934-1938
  int    OBTOTV96 1939-1941
  long   OBVTCH96 1942-1946
  long   OBVEXP96 1947-1951
  long   OBVSLF96 1952-1956
  long   OBVMCR96 1957-1961
  long   OBVMCD96 1962-1966
  long   OBVPRV96 1967-1971
  int    OBVVA96 1972-1975
  int    OBVCHM96 1976-1979
  int    OBVOFD96 1980-1983
  int    OBVSTL96 1984-1987
  int    OBVWCP96 1988-1991
  int    OBVOPR96 1992-1995
  int    OBVOPU96 1996-1999
  int    OBVOSR96 2000-2003
  int    OBDRV96 2004-2006
  long   OBDTCH96 2007-2011
  long   OBDEXP96 2012-2016
  long   OBDSLF96 2017-2021
  long   OBDMCR96 2022-2026
  long   OBDMCD96 2027-2031
  long   OBDPRV96 2032-2036
  int    OBDVA96 2037-2040
  int    OBDCHM96 2041-2044
  int    OBDOFD96 2045-2048
  int    OBDSTL96 2049-2052
  int    OBDWCP96 2053-2056
  int    OBDOPR96 2057-2060
  int    OBDOPU96 2061-2064
  int    OBDOSR96 2065-2068
  int    OBOTHV96 2069-2071
  long   OBOTCH96 2072-2076
  long   OBOEXP96 2077-2081
  int    OBOSLF96 2082-2085
  long   OBOMCR96 2086-2090
  long   OBOMCD96 2091-2095
  long   OBOPRV96 2096-2100
  int    OBOVA96 2101-2104
  int    OBOCHM96 2105-2107
  int    OBOOFD96 2108-2111
  int    OBOSTL96 2112-2115
  int    OBOWCP96 2116-2119
  int    OBOOPR96 2120-2123
  int    OBOOPU96 2124-2126
  int    OBOOSR96 2127-2130
  byte   OBCHIR96 2131-2132
  int    OBCTCH96 2133-2136
  int    OBCEXP96 2137-2140
  int    OBCSLF96 2141-2144
  int    OBCMCR96 2145-2148
  int    OBCMCD96 2149-2152
  int    OBCPRV96 2153-2156
  int    OBCVA96 2157-2159
  byte   OBCCHM96 2160-2160
  byte   OBCOFD96 2161-2161
  byte   OBCSTL96 2162-2162
  int    OBCWCP96 2163-2165
  int    OBCOPR96 2166-2168
  byte   OBCOPU96 2169-2169
  int    OBCOSR96 2170-2173
  int    OBNURS96 2174-2176
  long   OBNTCH96 2177-2181
  long   OBNEXP96 2182-2186
  int    OBNSLF96 2187-2190
  int    OBNMCR96 2191-2194
  long   OBNMCD96 2195-2199
  int    OBNPRV96 2200-2203
  int    OBNVA96 2204-2207
  byte   OBNCHM96 2208-2209
  int    OBNOFD96 2210-2212
  int    OBNSTL96 2213-2215
  int    OBNWCP96 2216-2218
  int    OBNOPR96 2219-2222
  byte   OBNOPU96 2223-2224
  int    OBNOSR96 2225-2228
  byte   OBOPTO96 2229-2230
  int    OBETCH96 2231-2234
  int    OBEEXP96 2235-2238
  int    OBESLF96 2239-2242
  int    OBEMCR96 2243-2245
  int    OBEMCD96 2246-2248
  int    OBEPRV96 2249-2252
  int    OBEVA96 2253-2255
  byte   OBECHM96 2256-2256
  byte   OBEOFD96 2257-2258
  byte   OBESTL96 2259-2260
  byte   OBEWCP96 2261-2261
  int    OBEOPR96 2262-2264
  int    OBEOPU96 2265-2267
  byte   OBEOSR96 2268-2269
  byte   OBASST96 2270-2271
  int    OBATCH96 2272-2275
  int    OBAEXP96 2276-2279
  int    OBASLF96 2280-2282
  int    OBAMCR96 2283-2286
  int    OBAMCD96 2287-2289
  int    OBAPRV96 2290-2293
  int    OBAVA96 2294-2296
  byte   OBACHM96 2297-2298
  int    OBAOFD96 2299-2301
  byte   OBASTL96 2302-2303
  byte   OBAWCP96 2304-2305
  byte   OBAOPR96 2306-2307
  byte   OBAOPU96 2308-2308
  int    OBAOSR96 2309-2311
  int    OBTHER96 2312-2314
  long   OBTTCH96 2315-2319
  long   OBTEXP96 2320-2324
  int    OBTSLF96 2325-2328
  int    OBTMCR96 2329-2332
  int    OBTMCD96 2333-2336
  int    OBTPRV96 2337-2340
  int    OBTVA96 2341-2344
  int    OBTCHM96 2345-2347
  int    OBTOFD96 2348-2351
  int    OBTSTL96 2352-2355
  int    OBTWCP96 2356-2359
  int    OBTOPR96 2360-2363
  byte   OBTOPU96 2364-2364
  int    OBTOSR96 2365-2368
  int    OPTOTV96 2369-2371
  long   OPFTCH96 2372-2376
  long   OPFEXP96 2377-2381
  long   OPFSLF96 2382-2386
  long   OPFMCR96 2387-2391
  long   OPFMCD96 2392-2396
  long   OPFPRV96 2397-2401
  long   OPFVA96 2402-2406
  int    OPFCHM96 2407-2410
  int    OPFOFD96 2411-2414
  int    OPFSTL96 2415-2418
  int    OPFWCP96 2419-2422
  long   OPFOPR96 2423-2427
  int    OPFOPU96 2428-2431
  int    OPFOSR96 2432-2435
  long   OPDEXP96 2436-2440
  long   OPDTCH96 2441-2445
  int    OPDSLF96 2446-2449
  int    OPDMCR96 2450-2453
  int    OPDMCD96 2454-2457
  long   OPDPRV96 2458-2462
  int    OPDVA96 2463-2466
  int    OPDCHM96 2467-2469
  int    OPDOFD96 2470-2473
  int    OPDSTL96 2474-2476
  int    OPDWCP96 2477-2480
  int    OPDOPR96 2481-2484
  int    OPDOPU96 2485-2487
  int    OPDOSR96 2488-2490
  byte   OPDRV96 2491-2492
  long   OPVTCH96 2493-2497
  long   OPVEXP96 2498-2502
  long   OPVSLF96 2503-2507
  long   OPVMCR96 2508-2512
  long   OPVMCD96 2513-2517
  long   OPVPRV96 2518-2522
  long   OPVVA96 2523-2527
  int    OPVCHM96 2528-2531
  int    OPVOFD96 2532-2535
  int    OPVSTL96 2536-2539
  int    OPVWCP96 2540-2543
  int    OPVOPR96 2544-2547
  int    OPVOPU96 2548-2551
  int    OPVOSR96 2552-2555
  int    OPSEXP96 2556-2559
  long   OPSTCH96 2560-2564
  int    OPSSLF96 2565-2568
  int    OPSMCR96 2569-2572
  int    OPSMCD96 2573-2576
  int    OPSPRV96 2577-2580
  int    OPSVA96 2581-2584
  int    OPSCHM96 2585-2587
  int    OPSOFD96 2588-2591
  int    OPSSTL96 2592-2594
  int    OPSWCP96 2595-2598
  int    OPSOPR96 2599-2602
  int    OPSOPU96 2603-2605
  byte   OPSOSR96 2606-2606
  int    OPOTHV96 2607-2609
  long   OPOTCH96 2610-2614
  long   OPOEXP96 2615-2619
  int    OPOSLF96 2620-2623
  long   OPOMCR96 2624-2628
  int    OPOMCD96 2629-2632
  long   OPOPRV96 2633-2637
  int    OPOVA96 2638-2641
  int    OPOCHM96 2642-2645
  int    OPOOFD96 2646-2649
  int    OPOSTL96 2650-2653
  int    OPOWCP96 2654-2657
  long   OPOOPR96 2658-2662
  int    OPOOPU96 2663-2666
  int    OPOOSR96 2667-2670
  long   OPPEXP96 2671-2675
  long   OPPTCH96 2676-2680
  int    OPPSLF96 2681-2684
  int    OPPMCR96 2685-2688
  int    OPPMCD96 2689-2692
  long   OPPPRV96 2693-2697
  int    OPPVA96 2698-2701
  byte   OPPCHM96 2702-2703
  int    OPPOFD96 2704-2707
  byte   OPPSTL96 2708-2708
  int    OPPWCP96 2709-2712
  int    OPPOPR96 2713-2716
  int    OPPOPU96 2717-2719
  int    OPPOSR96 2720-2722
  byte   ERTOT96 2723-2724
  long   ERFTCH96 2725-2729
  long   ERFEXP96 2730-2734
  int    ERFSLF96 2735-2738
  int    ERFMCR96 2739-2742
  int    ERFMCD96 2743-2746
  long   ERFPRV96 2747-2751
  int    ERFVA96 2752-2755
  int    ERFCHM96 2756-2758
  int    ERFOFD96 2759-2762
  int    ERFSTL96 2763-2765
  int    ERFWCP96 2766-2769
  int    ERFOPR96 2770-2773
  int    ERFOPU96 2774-2776
  long   ERFOSR96 2777-2781
  int    ERDEXP96 2782-2785
  int    ERDTCH96 2786-2789
  int    ERDSLF96 2790-2793
  int    ERDMCR96 2794-2797
  int    ERDMCD96 2798-2801
  int    ERDPRV96 2802-2805
  byte   ERDVA96 2806-2807
  int    ERDCHM96 2808-2810
  byte   ERDOFD96 2811-2812
  byte   ERDSTL96 2813-2814
  int    ERDWCP96 2815-2818
  int    ERDOPR96 2819-2822
  int    ERDOPU96 2823-2825
  byte   ERDOSR96 2826-2827
  byte   IPZERO96 2828-2828
  long   ZIFTCH96 2829-2833
  long   ZIFEXP96 2834-2838
  long   ZIFSLF96 2839-2843
  long   ZIFMCR96 2844-2848
  int    ZIFMCD96 2849-2852
  long   ZIFPRV96 2853-2857
  int    ZIFVA96 2858-2861
  byte   ZIFCHM96 2862-2862
  int    ZIFOFD96 2863-2866
  byte   ZIFSTL96 2867-2867
  byte   ZIFWCP96 2868-2868
  long   ZIFOPR96 2869-2873
  byte   ZIFOPU96 2874-2874
  byte   ZIFOSR96 2875-2875
  int    ZIDEXP96 2876-2879
  long   ZIDTCH96 2880-2884
  int    ZIDSLF96 2885-2888
  int    ZIDMCR96 2889-2892
  int    ZIDMCD96 2893-2896
  int    ZIDPRV96 2897-2900
  int    ZIDVA96 2901-2903
  byte   ZIDCHM96 2904-2904
  int    ZIDOFD96 2905-2907
  byte   ZIDSTL96 2908-2908
  int    ZIDWCP96 2909-2912
  int    ZIDOPR96 2913-2916
  int    ZIDOPU96 2917-2919
  byte   ZIDOSR96 2920-2920
  byte   IPDIS96 2921-2922
  long   IPFEXP96 2923-2928
  long   IPFTCH96 2929-2934
  long   IPFSLF96 2935-2939
  long   IPFMCR96 2940-2945
  long   IPFMCD96 2946-2951
  long   IPFPRV96 2952-2957
  long   IPFVA96 2958-2963
  int    IPFCHM96 2964-2967
  long   IPFOFD96 2968-2972
  int    IPFSTL96 2973-2976
  int    IPFWCP96 2977-2980
  long   IPFOPR96 2981-2985
  long   IPFOPU96 2986-2990
  long   IPFOSR96 2991-2995
  long   IPDEXP96 2996-3000
  long   IPDTCH96 3001-3005
  int    IPDSLF96 3006-3009
  long   IPDMCR96 3010-3014
  long   IPDMCD96 3015-3019
  long   IPDPRV96 3020-3024
  int    IPDVA96 3025-3027
  int    IPDCHM96 3028-3031
  int    IPDOFD96 3032-3034
  int    IPDSTL96 3035-3038
  int    IPDWCP96 3039-3042
  int    IPDOPR96 3043-3046
  int    IPDOPU96 3047-3050
  int    IPDOSR96 3051-3054
  int    IPNGTD96 3055-3057
  byte   DVTOT96 3058-3059
  long   DVTTCH96 3060-3064
  long   DVTEXP96 3065-3069
  long   DVTSLF96 3070-3074
  int    DVTMCR96 3075-3078
  int    DVTMCD96 3079-3082
  int    DVTPRV96 3083-3086
  int    DVTVA96 3087-3090
  int    DVTCHM96 3091-3093
  int    DVTOFD96 3094-3096
  int    DVTSTL96 3097-3100
  int    DVTWCP96 3101-3103
  int    DVTOPR96 3104-3107
  int    DVTOPU96 3108-3111
  int    DVTOSR96 3112-3115
  byte   DVGEN96 3116-3117
  long   DVGTCH96 3118-3122
  long   DVGEXP96 3123-3127
  int    DVGSLF96 3128-3131
  int    DVGMCR96 3132-3135
  int    DVGMCD96 3136-3139
  int    DVGPRV96 3140-3143
  int    DVGVA96 3144-3147
  int    DVGCHM96 3148-3150
  int    DVGOFD96 3151-3153
  int    DVGSTL96 3154-3156
  int    DVGWCP96 3157-3159
  int    DVGOPR96 3160-3163
  int    DVGOPU96 3164-3167
  int    DVGOSR96 3168-3171
  byte   DVORTH96 3172-3173
  long   DVOTCH96 3174-3178
  long   DVOEXP96 3179-3183
  long   DVOSLF96 3184-3188
  int    DVOMCR96 3189-3191
  int    DVOMCD96 3192-3195
  int    DVOPRV96 3196-3199
  byte   DVOVA96 3200-3200
  byte   DVOCHM96 3201-3201
  byte   DVOOFD96 3202-3202
  int    DVOSTL96 3203-3205
  byte   DVOWCP96 3206-3206
  int    DVOOPR96 3207-3210
  int    DVOOPU96 3211-3214
  int    DVOOSR96 3215-3218
  byte   HHTOTM96 3219-3220
  int    HHTOTD96 3221-3223
  byte   HHAGM96 3224-3225
  int    HHAGD96 3226-3228
  long   HHATCH96 3229-3234
  long   HHAEXP96 3235-3240
  int    HHASLF96 3241-3244
  long   HHAMCR96 3245-3249
  long   HHAMCD96 3250-3254
  long   HHAPRV96 3255-3259
  long   HHAVA96 3260-3264
  byte   HHACHM96 3265-3266
  int    HHAOFD96 3267-3270
  int    HHASTL96 3271-3274
  byte   HHAWCP96 3275-3275
  int    HHAOPR96 3276-3279
  int    HHAOPU96 3280-3282
  byte   HHAOSR96 3283-3283
  byte   HHINDM96 3284-3285
  int    HHINDD96 3286-3288
  long   HHNTCH96 3289-3293
  long   HHNEXP96 3294-3298
  long   HHNSLF96 3299-3303
  byte   HHNMCR96 3304-3305
  long   HHNMCD96 3306-3310
  long   HHNPRV96 3311-3315
  int    HHNVA96 3316-3319
  byte   HHNCHM96 3320-3320
  int    HHNOFD96 3321-3323
  int    HHNSTL96 3324-3326
  byte   HHNWCP96 3327-3327
  int    HHNOPR96 3328-3331
  byte   HHNOPU96 3332-3332
  byte   HHNOSR96 3333-3333
  byte   HHINFM96 3334-3335
  int    HHINFD96 3336-3338
  int    VISEXP96 3339-3342
  int    VISTCH96 3343-3346
  int    VISSLF96 3347-3350
  int    VISMCR96 3351-3353
  int    VISMCD96 3354-3356
  int    VISPRV96 3357-3359
  int    VISVA96 3360-3362
  int    VISCHM96 3363-3365
  int    VISOFD96 3366-3368
  int    VISSTL96 3369-3371
  byte   VISWCP96 3372-3372
  int    VISOPR96 3373-3375
  int    VISOPU96 3376-3378
  int    VISOSR96 3379-3381
  long   OTHTCH96 3382-3386
  long   OTHEXP96 3387-3391
  int    OTHSLF96 3392-3395
  int    OTHMCR96 3396-3399
  long   OTHMCD96 3400-3404
  long   OTHPRV96 3405-3409
  long   OTHVA96 3410-3414
  byte   OTHCHM96 3415-3415
  long   OTHOFD96 3416-3420
  int    OTHSTL96 3421-3424
  int    OTHWCP96 3425-3427
  int    OTHOPR96 3428-3431
  int    OTHOPU96 3432-3434
  int    OTHOSR96 3435-3437
  int    RXTOT96 3438-3440
  long   RXEXP96 3441-3445
  long   RXSLF96 3446-3450
  int    RXMCR96 3451-3454
  long   RXMCD96 3455-3459
  long   RXPRV96 3460-3464
  int    RXVA96 3465-3468
  int    RXCHM96 3469-3472
  int    RXOFD96 3473-3476
  int    RXSTL96 3477-3480
  int    RXWCP96 3481-3484
  int    RXOPR96 3485-3488
  int    RXOPU96 3489-3491
  int    RXOSR96 3492-3495
  double WGTRU2T 3496-3507
  double WGTSP2T 3508-3519
  int    VARSTRT2 3520-3522
  byte   VARPSU2 3523-3524
  double WTFAMF96 3525-3536
  double WTCFAM96 3537-3548
  double WTDPER96 3549-3560
  int    VARSTR96 3561-3563
  byte   VARPSU96 3564-3565
using H12.dat;

*DEFINE VARIABLE LABELS;
label variable DUID "DWELLING UNIT ID";
label variable PID "PERSON ID";
label variable DUPERSID "PERSON ID (DUID + PID)";
label variable FAMID1 "FAMILY IDENTIFIER (STUDENT MERGED IN)-R1";
label variable FAMID2 "FAMILY IDENTIFIER (STUDENT MERGED IN)-R2";
label variable FAMID96 "FAM IDENTIFIER (STUD MERGED IN)-12/31/96";
label variable FAMIDYR "ANNUAL FAMILY IDENTIFIER";
label variable CPSFAMID "CPS-LIKE FAMILY IDENTIFIER";
label variable RULETTR1 "RU LETTER - R1";
label variable RULETTR2 "RU LETTER - R2";
label variable RULETR96 "RU LETTER AS OF DEC 31";
label variable RUSIZE1 "RU SIZE - R1";
label variable RUSIZE2 "RU SIZE - R2";
label variable RUSIZE96 "RU SIZE AS OF DEC 31";
label variable RUCLASS1 "RU: STANDARD/NEW/STUDENT-R1";
label variable RUCLASS2 "RU: STANDARD/NEW/STUDENT-R2";
label variable RUCLAS96 "RU: STANDARD/NEW/STUDENT-12/31/96";
label variable FAMSIZE1 "RU SIZE INCLUDING STUDENTS - R1";
label variable FAMSIZE2 "RU SIZE INCLUDING STUDENTS - R2";
label variable FAMSZE96 "RU SIZE INCLUDING STUDENTS AS OF DEC 31";
label variable FMRS1231 "MEMBER OF RESPONDING 12/31 FAMILY";
label variable FAMS1231 "FAMILY SIZE OF RESPONDING 12/31 FAMILY";
label variable FAMSZEYR "SIZE OF RESPONDING ANNUALIZED FAMILY";
label variable FAMRFPYR "REFERENCE PERSON OF ANNUALIZED FAMILY";
label variable FCSZ1231 "FAM SIZE RESPONDING 12/31 CPS FAMILY";
label variable FCRP1231 "REF PERSON OF 12/31 CPS FAMILY";
label variable INRU1231 "PERSON WAS IN RU ON 12/31/96";
label variable INSC1231 "IN-SCOPE STATUS ON DECEMBER 31, 1996";
label variable REGION1 "CENSUS REGION - R1";
label variable REGION2 "CENSUS REGION - R2";
label variable REGION3 "CENSUS REGION - R3";
label variable REGION96 "CENSUS REGION AS OF DEC 31";
label variable MSA3 "MSA - R3";
label variable MSA96 "MSA AS OF DEC 31";
label variable REFPERS1 "PID OF REFERENCE PERSON - R1";
label variable REFPERS2 "PID OF REFERENCE PERSON - R2";
label variable REFPRS96 "PID OF REFERENCE PERSON - 12/31/96";
label variable RESP1 "1ST RESPONDENT INDICATOR FOR RND 1";
label variable RESP2 "1ST RESPONDENT INDICATOR FOR RND 2";
label variable RESP96 "1ST RESPONDENT INDICATOR AS OF 12/31/96";
label variable PROXY1 "WAS RESPONDENT A PROXY IN R1";
label variable PROXY2 "WAS RESPONDENT A PROXY IN R2";
label variable PROXY96 "WAS RESPONDENT A PROXY AS OF 12/31/96";
label variable BEGREFD1 "R1 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGREFM1 "R1 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGREFY1 "R1 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDREFD1 "REFERENCE PERIOD END DATE: DAY - R1";
label variable ENDREFM1 "REFERENCE PERIOD END DATE: MONTH - R1";
label variable ENDREFY1 "REFERENCE PERIOD END DATE: YEAR - R1";
label variable BEGREFD2 "R2 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGREFM2 "R2 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGREFY2 "R2 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDREFD2 "REFERENCE PERIOD END DATE: DAY - R2";
label variable ENDREFM2 "REFERENCE PERIOD END DATE: MONTH - R2";
label variable ENDREFY2 "REFERENCE PERIOD END DATE: YEAR - R2";
label variable BEGREFD3 "R3 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGREFM3 "R3 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGREFY3 "R3 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD96 "1996 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM96 "1996 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY96 "1996 REFERENCE PERIOD END DATE: YEAR";
label variable KEYNESS "PERSON KEY STATUS";
label variable INSCOPE1 "INSCOPE - R1";
label variable INSCOPE2 "INSCOPE - R2";
label variable INSCOP96 "INSCOPE - R3 START THROUGH 12/31/96";
label variable INSCOPE "WAS PERSON EVER INSCOPE IN 1996";
label variable ELIGRND1 "ELIGIBILITY - R1";
label variable ELIGRND2 "ELIGIBILITY - R2";
label variable ELGRND96 "ELIGIBILITY - R3 START THROUGH 12/31/96";
label variable ELIGIBLE "WAS PERSON EVER ELIGIBLE IN 1996";
label variable PSTATUS1 "PERSON DISPOSITION STATUS - R1";
label variable PSTATUS2 "PERSON DISPOSITION STATUS - R2";
label variable PSTATUS3 "PERSON DISPOSITION STATUS - R3";
label variable RURSLT1 "RU RESULT - R1";
label variable RURSLT2 "RU RESULT - R2";
label variable RURSLT3 "RU RESULT - R3";
label variable AGE1X "AGE-RD1 (EDITED/IMPUTED)";
label variable AGE2X "AGE-RD2 (EDITED/IMPUTED)";
label variable AGE96X "AGE - 12/31/96 (EDITED/IMPUTED)";
label variable DOBMM "DATE OF BIRTH: MONTH";
label variable DOBYY "DATE OF BIRTH: YEAR";
label variable SEX "SEX";
label variable RACEX "RACE (EDITED/IMPUTED)";
label variable RACETHNX "RACE/ETHNICITY (EDITED/IMPUTED)";
label variable HISPANX "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable HISPCAT "SPECIFIC HISPANIC ETHNICITY GROUP";
label variable MARRY1X "MARITAL STATUS - RD1 (EDITED/IMPUTED)";
label variable MARRY2X "MARITAL STATUS - RD2 (EDITED/IMPUTED)";
label variable MARRY96X "MARITAL STATUS-12/31/96 (EDITED/IMPUTED)";
label variable SPOUSID1 "PID OF SPOUSE - R1";
label variable SPOUSID2 "PID OF SPOUSE - R2";
label variable SPOUID96 "PID OF SPOUSE - 12/31/96";
label variable SPOUSIN1 "MARITAL STATUS W/ SPOUSE PRESENT-RD1";
label variable SPOUSIN2 "MARITAL STATUS W/ SPOUSE PRESENT-RD2";
label variable SPOUIN96 "MARITAL STATUS W/SPOUSE PRESENT-12/31/96";
label variable EDUCYR1 "COMPLETED YEARS OF EDUCATION-RD1";
label variable EDUCYR2 "COMPLETED YEARS OF EDUCATION-RD2";
label variable EDUCYR96 "COMPLETED YEARS OF EDUCATION - 12/31/96";
label variable HIGHDEG1 "HIGHEST DEGREE-RD1";
label variable HIGHDEG2 "HIGHEST DEGREE-RD2";
label variable HIDEG96 "HIGHEST DEGREE-12/31/96";
label variable FTSTUD1X "STUDENT STATUS IF AGES 17-23 - ROUND 1";
label variable FTSTUD2X "STUDENT STATUS IF AGES 17-23 - ROUND 2";
label variable FTSTU96X "STUDENT STATUS IF AGES 17-23 - 12/31/96";
label variable ACTDUTY1 "MILITARY FULL-TIME ACTIVE DUTY-RD1";
label variable ACTDUTY2 "MILITARY FULL-TIME ACTIVE DUTY-RD2";
label variable DIDSERVE "EVER SERVED IN ARMED FORCES";
label variable VETPVIET "SERVED IN POST-VIETNAM ERA";
label variable VETVIET "SERVED IN VIETNAM WAR ERA";
label variable VETKOR "SERVED IN KOREAN WAR ERA";
label variable VETWW "SERVED IN WWI OR WW2 ERA";
label variable VETOTH "SERVED IN OTHER PERIOD";
label variable REFREL1X "RELATION TO REF PERS-RD1(EDITED/IMPUTED)";
label variable REFREL2X "RELATION TO REF PERS-RD2(EDITED/IMPUTED)";
label variable RFREL96X "RELATION TO REF PERS 12/31/96 (EDIT/IMP)";
label variable MOMPID1X "PID OF MOM - R1";
label variable DADPID1X "PID OF DAD - R1";
label variable MOMPID2X "PID OF MOM - R2";
label variable DADPID2X "PID OF DAD - R2";
label variable SSIDISAB "SSI RECEIPT DUE TO DISABILITY";
label variable AFDC "DID PERS S CHECK INCLUDE AFDC OR ADC";
label variable FILEDITR "HAS PERSON FILED A FED INCOME TAX RETURN";
label variable WILLFILE "WILL PERSON FILE FED INCOME TAX RETURN";
label variable FILESTAT "PERSON S FILING STATUS";
label variable FILER "PRIMARY OR SECONDARY FILER";
label variable JNTINRU "JOINT FILER S MEMBERSHIP IN RU";
label variable JOINTPID "PID OF SECONDARY FILER";
label variable CLAIMDEP "DID/WILL PERS CLAIM DEPENDENTS ON RETURN";
label variable DEPENDNT "PERSON IS FLAGGED A DEPENDENT";
label variable DEPINRU "DEPENDENTS IN/OUT OF RU";
label variable DEPOUTSD "HOW MANY DEPENDENTS LIVE OUTSIDE RU";
label variable TAXFORM "TAX FORM PERSON WILL FILE";
label variable DEDUCTNS "ITEMIZE OR STANDARD DEDUCTION";
label variable ITMEDEXP "WILL PERSON ITEMIZE MEDICAL EXPENSE";
label variable MDEXPAMT "TOTAL AMOUNT FOR MEDICAL EXPENSES";
label variable NETMDDED "PERSON S NET MEDICAL EXPENSE DEDUCTION";
label variable TOTDED "TOTAL OF ALL ITEMIZED DEDUCTIONS";
label variable CLMHIP "DID/WILL PERS DEDUCT HLTH INSUR PREM";
label variable ELDISCR "DID/WILL PERS RECEIVE ELDERLY/DISAB CRED";
label variable EICREDIT "DID/WILL PERS RECEIVE EARNED INC CREDIT";
label variable UNEMTAX "TAXABLE PERCENTAGE OF UNEMPLOYMENT";
label variable INTRTAX "TAXABLE PERCENTAGE OF INTEREST";
label variable SSECTAX "TAXABLE PERCENTAGE OF SOCIAL SECURITY";
label variable IRASTAX "TAXABLE PERCENTAGE OF IRA INCOME";
label variable FOODSTMP "DID ANYONE PURCHASE FOOD STAMPS";
label variable FOODMNTH "NUMBER OF FOOD STAMPS PURCHASED";
label variable FOODCOST "AMOUNT FAMILY PAID FOR FOOD STAMPS";
label variable FOODVALU "MONTHLY VALUE OF FOOD STAMPS";
label variable TTLPNX "SUM OF INCOME VARS EXCL SALES, REFUND";
label variable POVCAT "POVERTY STATUS";
label variable WAGEPNX "ANN PSN INCOME FROM WAGE";
label variable WAGEIMP "WAGEPN IMPUTATION FLAG";
label variable BUSNPNX "ANN PSN INCOME FROM BUSINESS, EARN/LOSS";
label variable BUSNIMP "BUSNPN IMPUTATION FLAG";
label variable FARMPNX "ANN PSN INCOME FROM FARM, EARN/LOSS";
label variable FARMIMP "FARMPN IMPUTATION FLAG";
label variable INTRPNX "ANN PSN INCOME FROM INTEREST";
label variable INTRIMP "INTRPN IMPUTATION FLAG";
label variable DIVDPNX "ANN PSN INCOME FROM DIVIDEND";
label variable DIVDIMP "DIVDPN IMPUTATION FLAG";
label variable ALIMPNX "ANN PSN INCOME FROM ALIMONY";
label variable ALIMIMP "ALIMPN IMPUTATION FLAG";
label variable TRSTPNX "ANN PSN INCOME FROM TRUST/RENT,EARN/LOSS";
label variable TRSTIMP "TRSTPN IMPUTATION FLAG";
label variable PENSPNX "ANN PSN INCOME FROM PENSION";
label variable PENSIMP "PENSPN IMPUTATION FLAG";
label variable IRASPNX "ANN PSN INCOME FROM IRAS";
label variable IRASIMP "IRASPN IMPUTATION FLAG";
label variable SSECPNX "ANN PSN INCOME FROM SOCIAL SECURITY";
label variable SSECIMP "SSECPN IMPUTATION FLAG";
label variable UNEMPNX "ANN PSN INCOME FROM UNEMPLOYMENT COMP";
label variable UNEMIMP "UNEMPN IMPUTATION FLAG";
label variable WCMPPNX "ANN PSN INCOME FRM WORKMANS COMPENSATION";
label variable WCMPIMP "WCMPPN IMPUTATION FLAG";
label variable VETSPNX "ANN PSN INCOME FROM VETERANS PAYMENTS";
label variable VETSIMP "VETSPN IMPUTATION FLAG";
label variable CASHPNX "ANN PSN INCOME F/ OTHER REG CASH CONTRIB";
label variable CASHIMP "CASHPN IMPUTATION FLAG";
label variable OTHRPNX "ANN PSN INCOME FROM OTHER INCOME";
label variable OTHRIMP "OTHRPN IMPUTATION FLAG";
label variable CHLDPNX "ANN PSN INCOME FROM CHILD SUPPORT";
label variable CHLDIMP "CHLDPN IMPUTATION FLAG";
label variable PUBPNX "ANN PSN INCOME FROM PUBLIC ASSISTANCE";
label variable PUBIMP "PUBPN IMPUTATION FLAG";
label variable SSIPNX "ANN PSN INCOME FROM SUPPL SECURITY INCOM";
label variable SSIIMP "SSIPN IMPUTATION FLAG";
label variable SALEPNX "ANN PSN INCOME FROM SALES, EARN/LOSS";
label variable SALEIMP "SALEPN IMPUTATION FLAG";
label variable REFDPNX "ANN PSN INCOME FROM REFUND";
label variable REFDIMP "REFDPN IMPUTATION FLAG";
label variable EMPST1 "EMPLOYMENT STATUS RD 1";
label variable EMPST2 "EMPLOYMENT STATUS RD 2";
label variable EMPST96 "EMPLOYMENT STATUS ON 12/31/96";
label variable NWK1 "REASON NOT WORKING RD 1";
label variable NWK2 "REASON NOT WORKING RD 2";
label variable NWK96 "REASON NOT WORKING 12/31/96";
label variable SELFCM1 "SELF-EMPLOYED RD 1 CM JOB";
label variable SELFCM2 "SELF-EMPLOYED RD 2 CM JOB";
label variable SELFCM96 "SELF-EMPLOYED AT 12/31/96 CM JOB";
label variable PAYDR1 "PAID LEAVE TO VISIT DR RD 1 CM JOB";
label variable PAYDR2 "PAID LEAVE TO VISIT DR RD 2 CM JOB";
label variable PAYDR96 "PAID LEAVE TO VISIT DR 12/31/96 CM JOB";
label variable SICPAY1 "PAID SICK LEAVE RD 1 CM JOB";
label variable SICPAY2 "PAID SICK LEAVE RD 2 CM JOB";
label variable SICPAY96 "PAID SICK LEAVE AT 12/31/96 CM JOB";
label variable PAYVAC1 "PAID VACATION AT RD 1 CM JOB";
label variable PAYVAC2 "PAID VACATION AT RD 2 CM JOB";
label variable PAYVAC96 "PAID VACATION AT 12/31/96 CM JOB";
label variable RETPLN1 "PENSION PLAN RD 1 CM JOB";
label variable RETPLN2 "PENSION PLAN RD 2 CM JOB";
label variable RETPLN96 "PENSION PLAN AT 12/31/96 CM JOB";
label variable MORE1 "RD 1 CM JOB FIRM HAS MORE THAN 1 LOCAT";
label variable MORE2 "RD 2 CM JOB FIRM HAS MORE THAN 1 LOCAT";
label variable MORE96 "12/31/96 CMJ FIRM HAS MORE THAN 1 LOC";
label variable JOBORG1 "PRIVATE (PROFIT,NONPROFIT) GOV RD 1 CMJ";
label variable JOBORG2 "PRIVATE (PROFIT,NONPROFIT) GOV RD 2 CMJ";
label variable JOBORG96 "PRIV (PROFIT,NONPROFIT) GOV,12/31/96 CMJ";
label variable BSNTY1 "SOLE PROP, PARTNER, CORP, RD 1 CM JOB";
label variable BSNTY2 "SOLE PROP, PARTNER, CORP, RD 2 CM JOB";
label variable BSNTY96 "SOLE PROP, PARTNER, CORP, 12/31/96 CMJ";
label variable HRWG1X "HOURLY WAGE RD 1 CM JOB";
label variable HRWGIM1 "HRWG1X IMPUTATION FLAG";
label variable HRHOW1 "HOW HOURLY WAGE WAS CALCULATED R1";
label variable HRWG2X "HOURLY WAGE RD 2 CM JOB";
label variable HRWGIM2 "HRWG2X IMPUTATION FLAG";
label variable HRHOW2 "HOW HOURLY WAGE WAS CALCULATED RD2";
label variable HRWG96X "HOURLY WAGE AT 12/31/96 CM JOB";
label variable HRWGIM96 "HRWG96X IMPUTATION FLAG";
label variable HRHOW96 "HOW 12/31/96 HOURLY WAGE WAS CALCULATED";
label variable HELD1X "HEALTH INSURANCE HELD FROM RD 1 CM JOB";
label variable HELD2X "HEALTH INSURANCE HELD RD 2 CMJ";
label variable HELD96X "HEALTH INSURANCE HELD 12/31/96 CMJ";
label variable OFFER1X "HEALTH INSURANCE OFFERED FROM RD 1 CMJ";
label variable OFFER2X "HEALTH INSURANCE OFFERED FROM RD 2 CMJ";
label variable OFFER96X "HEALTH INSURANCE OFFERED 12/31/96 CMJ";
label variable CHOIC1 "CHOICE OF HEALTH PLANS FROM RD 1 CM JOB";
label variable CHOIC2 "CHOICE OF HEALTH PLANS FROM RD 2 CM JOB";
label variable CHOIC96 "CHOICE OF HEALTH PLANS AT 12/31/96 CMJ";
label variable DISVW1X "DISAVOWED HEALTH INSURANCE AT R1 CM JOB";
label variable DISVW2X "DISAVOWED HEALTH INSURANCE R2 CMJ";
label variable DISVW96X "DISAVOWED HEALTH INSURANCE 12/31/96 CMJ";
label variable HOUR1 "HOURS PER WEEK RD 1 CM JOB";
label variable HOUR2 "HOURS PER WEEK RD 2 CM JOB";
label variable HOUR96 "HOURS PER WEEK AT 12/31/96 CM JOB";
label variable NUMEMP1 "EST SIZE RD 1 CM JOB";
label variable NUMEMP2 "EST SIZE RD 2 CM JOB";
label variable NUMEMP96 "EST SIZE 12/31/96 CM JOB";
label variable CIND1 "CONDENSED INDUSTRY CODE RD1 CM JOB";
label variable CIND2 "CONDENSED INDUSTRY CODE RD2 CM JOB";
label variable CIND96 "CONDENSED INDUSTRY CODE IND96 CM JOB";
label variable COCCP1 "CONDENSED OCCUPATION CODE-R1 CM JOB";
label variable COCCP2 "CONDENSED OCCUPATION CODE-R2 CM JOB";
label variable COCCP96 "CONDENSD OCCUPATION CODE-12/31/96 CM JOB";
label variable UNION1 "UNION STATUS AT RD 1 CM JOB";
label variable UNION2 "UNION STATUS AT RD 2 CM JOB";
label variable UNION96 "UNION STATUS AT 12/31/96 CM JOB";
label variable SHFTWK1 "IRREGULAR WORK SHIFT RD 1 CMJ";
label variable SHFTWK2 "IRREGULAR WORK SHIFT RD 2 CMJ";
label variable SHFTWK96 "IRREGULAR WORK SHIFT AT 12/31/96 CMJ";
label variable BGNWK1 "USUAL START TIME OF R1 CM JOB";
label variable BGNWK2 "USUAL START TIME OF R2 CM JOB";
label variable BGNWK96 "USUAL START TIME OF 12/31/96 CM JOB";
label variable ENDWK1 "USUAL END TIME OF RD 1 CM JOB";
label variable ENDWK2 "USUAL END TIME OF RD 2 CM JOB";
label variable ENDWK96 "USUAL END TIME OF 12/31/96 CM JOB";
label variable STJBMM1 "MONTH STARTED R1 CM JOB";
label variable STJBDD1 "DAY STARTED R1 CM JOB";
label variable STJBYY1 "YEAR STARTED R1 CM JOB";
label variable STJBMM2 "MONTH STARTED R2 CM JOB";
label variable STJBDD2 "DAY STARTED R2 CM JOB";
label variable STJBYY2 "YEAR STARTED R2 CM JOB";
label variable STJBMM96 "MONTH STARTED 12/31/96 CM JOB";
label variable STJBDD96 "DAY STARTED 12/31/96 CM JOB";
label variable STJBYY96 "YEAR STARTED 12/31/96 CM JOB";
label variable EVRET96 "EVER RETIRED AS OF 12/31/96";
label variable EVRWRK "EVER WORKED FOR PAY AS OF 12/31/96";
label variable MORJOB1 "HAS MORE THAN ONE JOB RD 1";
label variable MORJOB2 "HAS MORE THAN ONE JOB RD 2";
label variable MORJOB96 "HAS MORE THAN ONE JOB ON 12/31/96";
label variable CHNGJ12 "CHANGED RD 1 CM JOB IN RD 2";
label variable CHNGJ231 "CHANGED RD 2 CM JOB BY 12/31/96";
label variable YCHJB12 "WHY CHANGED R1 CM JOB IN R2";
label variable YCHJB231 "WHY CHANGED R2 CM JOB BY 12/31/96";
label variable CHMPNOW1 "PID COV BY CHAMPUS/VA - RD1 INT DATE";
label variable MCAID1 "PID COVERED BY MEDICAID - RD 1";
label variable MCAID1X "PID COVERED BY MEDICAID - RD1 (EDITED)";
label variable OTPUBA1 "PID COV BY/PAYS OTH GOV MCAID HMO - RD1";
label variable OTPUBB1 "PID COV BY OTH PUB NOT MCAID HMO - RD1";
label variable STATPRG1 "PID COV FRM STATE-SPECIFIC PROG - RD1";
label variable PUBLIC1 "PID COV FRM PUBLIC INS PLAN - RD1";
label variable OTGOVPY1 "ANY GOVT PAYS PART MCAID HMO PREM - RD 1";
label variable MCARNOW1 "PID COV BY MEDICARE - RD1 INT DATE";
label variable MCARNW1X "PID COV BY MEDICARE-RD1 INT DATE (ED)";
label variable PRIV1 "PID HAS PRIV HLTH INS COVERAGE - RD1";
label variable PRIVEG1 "PID HAS COV FRM EMP GROUP PLAN - RD1";
label variable PRIVU1 "PID HAS COV FROM UNION GROUP PLAN - RD1";
label variable PRIVS1 "PID HAS COV FRM SELF-EMP-1 PLAN - RD";
label variable PRIVOG1 "PID HAS COV FRM OTH GROUP PLAN - RD1";
label variable PRIVNG1 "PID HAS COV FRM NONGROUP PLAN - RD1";
label variable PRGVPYA1 "NON-EMP PRIV COV FEDS PAY PART - RD1";
label variable PRGVPYB1 "NON-EMP PRIV COV OTH GOV PAYS PART - RD1";
label variable PRIVDK1 "PID HAS COV FRM PRIV DK PLAN - RD1";
label variable PRIVOUT1 "PID HAS COV FRM HOLDER OUTSIDE RU - RD1";
label variable HPRIV1 "PID IS HOLDER OF PRIV INS PLAN - RD1";
label variable HPRIVEG1 "PID IS HOLDER OF EMP GROUP PLAN - RD1";
label variable HPRIVU1 "PID IS HOLDER OF UNION GRP PLAN - RD1";
label variable HPRIVS1 "PID IS HOLDER OF SELF-EMP-1 INS - RD1";
label variable HPRIVOG1 "PID IS HOLDER OF OTH GROUP PLAN - RD1";
label variable HPRIVNG1 "PID IS HOLDER OF NONGROUP PLAN - RD1";
label variable HPRIVDK1 "PID IS HOLDER OF PRIV DK PLAN - RD1";
label variable MCRHMO1 "PID ENROLLED IN MEDICARE HMO - R1";
label variable UPRHMO1 "UPDATED: PID ENROLLED IN PRV HMO - R1";
label variable UPRMNC1 "UPDATED: PID ENROLLED PRV MNGED CARE- R1";
label variable UPUBHMO1 "UPDATED: PID ENROLLED IN PUB HMO - R1";
label variable UPUBMNC1 "UPDATED: PID ENROLLED PUB MNGED CARE- R1";
label variable INSURED1 "PID IS INSURED - RD1";
label variable CHJA96X "COVERED BY CHAMPUS/CHAMPVA IN JAN96 (ED)";
label variable CHFE96X "COVERED BY CHAMPUS/CHAMPVA IN FEB96 (ED)";
label variable CHMA96X "COVERED BY CHAMPUS/CHAMPVA IN MAR96 (ED)";
label variable CHAP96X "COVERED BY CHAMPUS/CHAMPVA IN APR96 (ED)";
label variable CHMY96X "COVERED BY CHAMPUS/CHAMPVA IN MAY96 (ED)";
label variable CHJU96X "COVERED BY CHAMPUS/CHAMPVA IN JUN96 (ED)";
label variable CHJL96X "COVERED BY CHAMPUS/CHAMPVA IN JUL96 (ED)";
label variable CHAU96X "COVERED BY CHAMPUS/CHAMPVA IN AUG96 (ED)";
label variable CHSE96X "COVERED BY CHAMPUS/CHAMPVA IN SEP96 (ED)";
label variable CHOC96X "COVERED BY CHAMPUS/CHAMPVA IN OCT96 (ED)";
label variable CHNO96X "COVERED BY CHAMPUS/CHAMPVA IN NOV96 (ED)";
label variable CHDE96X "COVERED BY CHAMPUS/CHAMPVA IN DEC96 (ED)";
label variable MCRJA96 "COVERED BY MEDICARE IN JAN96";
label variable MCRFE96 "COVERED BY MEDICARE IN FEB96";
label variable MCRMA96 "COVERED BY MEDICARE IN MAR96";
label variable MCRAP96 "COVERED BY MEDICARE IN APR96";
label variable MCRMY96 "COVERED BY MEDICARE IN MAY96";
label variable MCRJU96 "COVERED BY MEDICARE IN JUN96";
label variable MCRJL96 "COVERED BY MEDICARE IN JUL96";
label variable MCRAU96 "COVERED BY MEDICARE IN AUG96";
label variable MCRSE96 "COVERED BY MEDICARE IN SEPT96";
label variable MCROC96 "COVERED BY MEDICARE IN OCT96";
label variable MCRNO96 "COVERED BY MEDICARE IN NOV96";
label variable MCRDE96 "COVERED BY MEDICARE IN DEC96";
label variable MCRJA96X "COVERED BY MEDICARE IN JAN96 (ED)";
label variable MCRFE96X "COVERED BY MEDICARE IN FEB96 (ED)";
label variable MCRMA96X "COVERED BY MEDICARE IN MAR96 (ED)";
label variable MCRAP96X "COVERED BY MEDICARE IN APR96 (ED)";
label variable MCRMY96X "COVERED BY MEDICARE IN MAY96 (ED)";
label variable MCRJU96X "COVERED BY MEDICARE IN JUN96 (ED)";
label variable MCRJL96X "COVERED BY MEDICARE IN JUL96 (ED)";
label variable MCRAU96X "COVERED BY MEDICARE IN AUG96 (ED)";
label variable MCRSE96X "COVERED BY MEDICARE IN SEP96 (ED)";
label variable MCROC96X "COVERED BY MEDICARE IN OCT96 (ED)";
label variable MCRNO96X "COVERED BY MEDICARE IN NOV96 (ED)";
label variable MCRDE96X "COVERED BY MEDICARE IN DEC96 (ED)";
label variable MCDJA96 "COVERED BY MEDICAID IN JAN96";
label variable MCDFE96 "COVERED BY MEDICAID IN FEB96";
label variable MCDMA96 "COVERED BY MEDICAID IN MAR96";
label variable MCDAP96 "COVERED BY MEDICAID IN APR96";
label variable MCDMY96 "COVERED BY MEDICAID IN MAY96";
label variable MCDJU96 "COVERED BY MEDICAID IN JUN96";
label variable MCDJL96 "COVERED BY MEDICAID IN JUL96";
label variable MCDAU96 "COVERED BY MEDICAID IN AUG96";
label variable MCDSE96 "COVERED BY MEDICAID IN SEPT96";
label variable MCDOC96 "COVERED BY MEDICAID IN OCT96";
label variable MCDNO96 "COVERED BY MEDICAID IN NOV96";
label variable MCDDE96 "COVERED BY MEDICAID IN DEC96";
label variable MCDJA96X "COVERED BY MEDICAID IN JAN96 (ED)";
label variable MCDFE96X "COVERED BY MEDICAID IN FEB96 (ED)";
label variable MCDMA96X "COVERED BY MEDICAID IN MAR96 (ED)";
label variable MCDAP96X "COVERED BY MEDICAID IN APR96 (ED)";
label variable MCDMY96X "COVERED BY MEDICAID IN MAY96 (ED)";
label variable MCDJU96X "COVERED BY MEDICAID IN JUN96 (ED)";
label variable MCDJL96X "COVERED BY MEDICAID IN JUL96 (ED)";
label variable MCDAU96X "COVERED BY MEDICAID IN AUG96 (ED)";
label variable MCDSE96X "COVERED BY MEDICAID IN SEP96 (ED)";
label variable MCDOC96X "COVERED BY MEDICAID IN OCT96 (ED)";
label variable MCDNO96X "COVERED BY MEDICAID IN NOV96 (ED)";
label variable MCDDE96X "COVERED BY MEDICAID IN DEC96 (ED)";
label variable OPAJA96 "COV BY OTHER PUBLIC A INS IN JAN96";
label variable OPAFE96 "COV BY OTHER PUBLIC A INS IN FEB96";
label variable OPAMA96 "COV BY OTHER PUBLIC A INS IN MAR96";
label variable OPAAP96 "COV BY OTHER PUBLIC A INS IN APR96";
label variable OPAMY96 "COV BY OTHER PUBLIC A INS IN MAY96";
label variable OPAJU96 "COV BY OTHER PUBLIC A INS IN JUN96";
label variable OPAJL96 "COV BY OTHER PUBLIC A INS IN JUL96";
label variable OPAAU96 "COV BY OTHER PUBLIC A INS IN AUG96";
label variable OPASE96 "COV BY OTHER PUBLIC A INS IN SEP96";
label variable OPAOC96 "COV BY OTHER PUBLIC A INS IN OCT96";
label variable OPANO96 "COV BY OTHER PUBLIC A INS IN NOV96";
label variable OPADE96 "COV BY OTHER PUBLIC A INS IN DEC96";
label variable OPBJA96 "COV BY OTHER PUBLIC B INS IN JAN96";
label variable OPBFE96 "COV BY OTHER PUBLIC B INS IN FEB96";
label variable OPBMA96 "COV BY OTHER PUBLIC B INS IN MAR96";
label variable OPBAP96 "COV BY OTHER PUBLIC B INS IN APR96";
label variable OPBMY96 "COV BY OTHER PUBLIC B INS IN MAY96";
label variable OPBJU96 "COV BY OTHER PUBLIC B INS IN JUN96";
label variable OPBJL96 "COV BY OTHER PUBLIC B INS IN JUL96";
label variable OPBAU96 "COV BY OTHER PUBLIC B INS IN AUG96";
label variable OPBSE96 "COV BY OTHER PUBLIC B INS IN SEP96";
label variable OPBOC96 "COV BY OTHER PUBLIC B INS IN OCT96";
label variable OPBNO96 "COV BY OTHER PUBLIC B INS IN NOV96";
label variable OPBDE96 "COV BY OTHER PUBLIC B INS IN DEC96";
label variable STAJA96 "COVERED BY OTHER STATE PROG IN JAN96";
label variable STAFE96 "COVERED BY OTHER STATE PROG IN FEB96";
label variable STAMA96 "COVERED BY OTHER STATE PROG IN MAR96";
label variable STAAP96 "COVERED BY OTHER STATE PROG IN APR96";
label variable STAMY96 "COVERED BY OTHER STATE PROG IN MAY96";
label variable STAJU96 "COVERED BY OTHER STATE PROG IN JUN96";
label variable STAJL96 "COVERED BY OTHER STATE PROG IN JUL96";
label variable STAAU96 "COVERED BY OTHER STATE PROG IN AUG96";
label variable STASE96 "COVERED BY OTHER STATE PROG IN SEP96";
label variable STAOC96 "COVERED BY OTHER STATE PROG IN OCT96";
label variable STANO96 "COVERED BY OTHER STATE PROG IN NOV96";
label variable STADE96 "COVERED BY OTHER STATE PROG IN DEC96";
label variable PUBJA96X "COVRD BY ANY PUBLIC INS IN JAN96 (ED)";
label variable PUBFE96X "COVRD BY ANY PUBLIC INS IN FEB96 (ED)";
label variable PUBMA96X "COVRD BY ANY PUBLIC INS IN MAR96 (ED)";
label variable PUBAP96X "COVRD BY ANY PUBLIC INS IN APR96 (ED)";
label variable PUBMY96X "COVRD BY ANY PUBLIC INS IN MAY96 (ED)";
label variable PUBJU96X "COVRD BY ANY PUBLIC INS IN JUN96 (ED)";
label variable PUBJL96X "COVRD BY ANY PUBLIC INS IN JUL96 (ED)";
label variable PUBAU96X "COVRD BY ANY PUBLIC INS IN AUG96 (ED)";
label variable PUBSE96X "COVRD BY ANY PUBLIC INS IN SEP96 (ED)";
label variable PUBOC96X "COVRD BY ANY PUBLIC INS IN OCT96 (ED)";
label variable PUBNO96X "COVRD BY ANY PUBLIC INS IN NOV96 (ED)";
label variable PUBDE96X "COVRD BY ANY PUBLIC INS IN DEC96 (ED)";
label variable PEGJA96 "COVERED BY EMPL UNION INS IN JAN96";
label variable PEGFE96 "COVERED BY EMPL UNION INS IN FEB96";
label variable PEGMA96 "COVERED BY EMPL UNION INS IN MAR96";
label variable PEGAP96 "COVERED BY EMPL UNION INS IN APR96";
label variable PEGMY96 "COVERED BY EMPL UNION INS IN MAY96";
label variable PEGJU96 "COVERED BY EMPL UNION INS IN JUN96";
label variable PEGJL96 "COVERED BY EMPL UNION INS IN JUL96";
label variable PEGAU96 "COVERED BY EMPL UNION INS IN AUG96";
label variable PEGSE96 "COVERED BY EMPL UNION INS IN SEP96";
label variable PEGOC96 "COVERED BY EMPL UNION INS IN OCT96";
label variable PEGNO96 "COVERED BY EMPL UNION INS IN NOV96";
label variable PEGDE96 "COVERED BY EMPL UNION INS IN DEC96";
label variable PDKJA96 "COVRD BY PRIV INS (SOURCE UNKNWN) JAN96";
label variable PDKFE96 "COVRD BY PRIV INS (SOURCE UNKNWN) FEB96";
label variable PDKMA96 "COVRD BY PRIV INS (SOURCE UNKNWN) MAR96";
label variable PDKAP96 "COVRD BY PRIV INS (SOURCE UNKNWN) APR96";
label variable PDKMY96 "COVRD BY PRIV INS (SOURCE UNKNWN) MAY96";
label variable PDKJU96 "COVRD BY PRIV INS (SOURCE UNKNWN) JUN96";
label variable PDKJL96 "COVRD BY PRIV INS (SOURCE UNKNWN) JUL96";
label variable PDKAU96 "COVRD BY PRIV INS (SOURCE UNKNWN) AUG96";
label variable PDKSE96 "COVRD BY PRIV INS (SOURCE UNKNWN) SEP96";
label variable PDKOC96 "COVRD BY PRIV INS (SOURCE UNKNWN) OCT96";
label variable PDKNO96 "COVRD BY PRIV INS (SOURCE UNKNWN) NOV96";
label variable PDKDE96 "COVRD BY PRIV INS (SOURCE UNKNWN) DEC96";
label variable PNGJA96 "COVERED BY NONGROUP INS IN JAN96";
label variable PNGFE96 "COVERED BY NONGROUP INS IN FEB96";
label variable PNGMA96 "COVERED BY NONGROUP INS IN MAR96";
label variable PNGAP96 "COVERED BY NONGROUP INS IN APR96";
label variable PNGMY96 "COVERED BY NONGROUP INS IN MAY96";
label variable PNGJU96 "COVERED BY NONGROUP INS IN JUN96";
label variable PNGJL96 "COVERED BY NONGROUP INS IN JUL96";
label variable PNGAU96 "COVERED BY NONGROUP INS IN AUG96";
label variable PNGSE96 "COVERED BY NONGROUP INS IN SEP96";
label variable PNGOC96 "COVERED BY NONGROUP INS IN OCT96";
label variable PNGNO96 "COVERED BY NONGROUP INS IN NOV96";
label variable PNGDE96 "COVERED BY NONGROUP INS IN DEC96";
label variable POGJA96 "COVERED BY OTHER GROUP INS IN JAN96";
label variable POGFE96 "COVERED BY OTHER GROUP INS IN FEB96";
label variable POGMA96 "COVERED BY OTHER GROUP INS IN MAR96";
label variable POGAP96 "COVERED BY OTHER GROUP INS IN APR96";
label variable POGMY96 "COVERED BY OTHER GROUP INS IN MAY96";
label variable POGJU96 "COVERED BY OTHER GROUP INS IN JUN96";
label variable POGJL96 "COVERED BY OTHER GROUP INS IN JUL96";
label variable POGAU96 "COVERED BY OTHER GROUP INS IN AUG96";
label variable POGSE96 "COVERED BY OTHER GROUP INS IN SEP96";
label variable POGOC96 "COVERED BY OTHER GROUP INS IN OCT96";
label variable POGNO96 "COVERED BY OTHER GROUP INS IN NOV96";
label variable POGDE96 "COVERED BY OTHER GROUP INS IN DEC96";
label variable PRSJA96 "COVERED BY SELF-EMP-1 INS IN JAN96";
label variable PRSFE96 "COVERED BY SELF-EMP-1 INS IN FEB96";
label variable PRSMA96 "COVERED BY SELF-EMP-1 INS IN MAR96";
label variable PRSAP96 "COVERED BY SELF-EMP-1 INS IN APR96";
label variable PRSMY96 "COVERED BY SELF-EMP-1 INS IN MAY96";
label variable PRSJU96 "COVERED BY SELF-EMP-1 INS IN JUN96";
label variable PRSJL96 "COVERED BY SELF-EMP-1 INS IN JUL96";
label variable PRSAU96 "COVERED BY SELF-EMP-1 INS IN AUG96";
label variable PRSSE96 "COVERED BY SELF-EMP-1 INS IN SEP96";
label variable PRSOC96 "COVERED BY SELF-EMP-1 INS IN OCT96";
label variable PRSNO96 "COVERED BY SELF-EMP-1 INS IN NOV96";
label variable PRSDE96 "COVERED BY SELF-EMP-1 INS IN DEC96";
label variable POUJA96 "COVERED BY HOLDER OUTSIDE OF RU IN JAN96";
label variable POUFE96 "COVERED BY HOLDER OUTSIDE OF RU IN FEB96";
label variable POUMA96 "COVERED BY HOLDER OUTSIDE OF RU IN MAR96";
label variable POUAP96 "COVERED BY HOLDER OUTSIDE OF RU IN APR96";
label variable POUMY96 "COVERED BY HOLDER OUTSIDE OF RU IN MAY96";
label variable POUJU96 "COVERED BY HOLDER OUTSIDE OF RU IN JUN96";
label variable POUJL96 "COVERED BY HOLDER OUTSIDE OF RU IN JUL96";
label variable POUAU96 "COVERED BY HOLDER OUTSIDE OF RU IN AUG96";
label variable POUSE96 "COVERED BY HOLDER OUTSIDE OF RU IN SEP96";
label variable POUOC96 "COVERED BY HOLDER OUTSIDE OF RU IN OCT96";
label variable POUNO96 "COVERED BY HOLDER OUTSIDE OF RU IN NOV96";
label variable POUDE96 "COVERED BY HOLDER OUTSIDE OF RU IN DEC96";
label variable PRIJA96 "COVERED BY PRIVATE INS IN JAN96";
label variable PRIFE96 "COVERED BY PRIVATE INS IN FEB96";
label variable PRIMA96 "COVERED BY PRIVATE INS IN MAR96";
label variable PRIAP96 "COVERED BY PRIVATE INS IN APR96";
label variable PRIMY96 "COVERED BY PRIVATE INS IN MAY96";
label variable PRIJU96 "COVERED BY PRIVATE INS IN JUN96";
label variable PRIJL96 "COVERED BY PRIVATE INS IN JUL96";
label variable PRIAU96 "COVERED BY PRIVATE INS IN AUG96";
label variable PRISE96 "COVERED BY PRIVATE INS IN SEP96";
label variable PRIOC96 "COVERED BY PRIVATE INS IN OCT96";
label variable PRINO96 "COVERED BY PRIVATE INS IN NOV96";
label variable PRIDE96 "COVERED BY PRIVATE INS IN DEC96";
label variable HPEJA96 "HOLDER OF EMPL UNION INS IN JAN96";
label variable HPEFE96 "HOLDER OF EMPL UNION INS IN FEB96";
label variable HPEMA96 "HOLDER OF EMPL UNION INS IN MAR96";
label variable HPEAP96 "HOLDER OF EMPL UNION INS IN APR96";
label variable HPEMY96 "HOLDER OF EMPL UNION INS IN MAY96";
label variable HPEJU96 "HOLDER OF EMPL UNION INS IN JUN96";
label variable HPEJL96 "HOLDER OF EMPL UNION INS IN JUL96";
label variable HPEAU96 "HOLDER OF EMPL UNION INS IN AUG96";
label variable HPESE96 "HOLDER OF EMPL UNION INS IN SEP96";
label variable HPEOC96 "HOLDER OF EMPL UNION INS IN OCT96";
label variable HPENO96 "HOLDER OF EMPL UNION INS IN NOV96";
label variable HPEDE96 "HOLDER OF EMPL UNION INS IN DEC96";
label variable HPDJA96 "HOLDER OF PRIV INS (SOURCE UNKNWN) JAN96";
label variable HPDFE96 "HOLDER OF PRIV INS (SOURCE UNKNWN) FEB96";
label variable HPDMA96 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAR96";
label variable HPDAP96 "HOLDER OF PRIV INS (SOURCE UNKNWN) APR96";
label variable HPDMY96 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAY96";
label variable HPDJU96 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUN96";
label variable HPDJL96 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUL96";
label variable HPDAU96 "HOLDER OF PRIV INS (SOURCE UNKNWN) AUG96";
label variable HPDSE96 "HOLDER OF PRIV INS (SOURCE UNKNWN) SEP96";
label variable HPDOC96 "HOLDER OF PRIV INS (SOURCE UNKNWN) OCT96";
label variable HPDNO96 "HOLDER OF PRIV INS (SOURCE UNKNWN) NOV96";
label variable HPDDE96 "HOLDER OF PRIV INS (SOURCE UNKNWN) DEC96";
label variable HPNJA96 "HOLDER OF NONGROUP INS IN JAN96";
label variable HPNFE96 "HOLDER OF NONGROUP INS IN FEB96";
label variable HPNMA96 "HOLDER OF NONGROUP INS IN MAR96";
label variable HPNAP96 "HOLDER OF NONGROUP INS IN APR96";
label variable HPNMY96 "HOLDER OF NONGROUP INS IN MAY96";
label variable HPNJU96 "HOLDER OF NONGROUP INS IN JUN96";
label variable HPNJL96 "HOLDER OF NONGROUP INS IN JUL96";
label variable HPNAU96 "HOLDER OF NONGROUP INS IN AUG96";
label variable HPNSE96 "HOLDER OF NONGROUP INS IN SEP96";
label variable HPNOC96 "HOLDER OF NONGROUP INS IN OCT96";
label variable HPNNO96 "HOLDER OF NONGROUP INS IN NOV96";
label variable HPNDE96 "HOLDER OF NONGROUP INS IN DEC96";
label variable HPOJA96 "HOLDER OF OTHER GROUP INS IN JAN96";
label variable HPOFE96 "HOLDER OF OTHER GROUP INS IN FEB96";
label variable HPOMA96 "HOLDER OF OTHER GROUP INS IN MAR96";
label variable HPOAP96 "HOLDER OF OTHER GROUP INS IN APR96";
label variable HPOMY96 "HOLDER OF OTHER GROUP INS IN MAY96";
label variable HPOJU96 "HOLDER OF OTHER GROUP INS IN JUN96";
label variable HPOJL96 "HOLDER OF OTHER GROUP INS IN JUL96";
label variable HPOAU96 "HOLDER OF OTHER GROUP INS IN AUG96";
label variable HPOSE96 "HOLDER OF OTHER GROUP INS IN SEP96";
label variable HPOOC96 "HOLDER OF OTHER GROUP INS IN OCT96";
label variable HPONO96 "HOLDER OF OTHER GROUP INS IN NOV96";
label variable HPODE96 "HOLDER OF OTHER GROUP INS IN DEC96";
label variable HPSJA96 "HOLDER OF SELF-EMP-1 INS IN JAN96";
label variable HPSFE96 "HOLDER OF SELF-EMP-1 INS IN FEB96";
label variable HPSMA96 "HOLDER OF SELF-EMP-1 INS IN MAR96";
label variable HPSAP96 "HOLDER OF SELF-EMP-1 INS IN APR96";
label variable HPSMY96 "HOLDER OF SELF-EMP-1 INS IN MAY96";
label variable HPSJU96 "HOLDER OF SELF-EMP-1 INS IN JUN96";
label variable HPSJL96 "HOLDER OF SELF-EMP-1 INS IN JUL96";
label variable HPSAU96 "HOLDER OF SELF-EMP-1 INS IN AUG96";
label variable HPSSE96 "HOLDER OF SELF-EMP-1 INS IN SEP96";
label variable HPSOC96 "HOLDER OF SELF-EMP-1 INS IN OCT96";
label variable HPSNO96 "HOLDER OF SELF-EMP-1 INS IN NOV96";
label variable HPSDE96 "HOLDER OF SELF-EMP-1 INS IN DEC96";
label variable HPRJA96 "HOLDER OF PRIVATE INSURANCE IN JAN96";
label variable HPRFE96 "HOLDER OF PRIVATE INSURANCE IN FEB96";
label variable HPRMA96 "HOLDER OF PRIVATE INSURANCE IN MAR96";
label variable HPRAP96 "HOLDER OF PRIVATE INSURANCE IN APR96";
label variable HPRMY96 "HOLDER OF PRIVATE INSURANCE IN MAY96";
label variable HPRJU96 "HOLDER OF PRIVATE INSURANCE IN JUN96";
label variable HPRJL96 "HOLDER OF PRIVATE INSURANCE IN JUL96";
label variable HPRAU96 "HOLDER OF PRIVATE INSURANCE IN AUG96";
label variable HPRSE96 "HOLDER OF PRIVATE INSURANCE IN SEP96";
label variable HPROC96 "HOLDER OF PRIVATE INSURANCE IN OCT96";
label variable HPRNO96 "HOLDER OF PRIVATE INSURANCE IN NOV96";
label variable HPRDE96 "HOLDER OF PRIVATE INSURANCE IN DEC96";
label variable INSJA96X "COVRD BY HOSP/MED INS IN JAN96 (ED)";
label variable INSFE96X "COVRD BY HOSP/MED INS IN FEB96 (ED)";
label variable INSMA96X "COVRD BY HOSP/MED INS IN MAR96 (ED)";
label variable INSAP96X "COVRD BY HOSP/MED INS IN APR96 (ED)";
label variable INSMY96X "COVRD BY HOSP/MED INS IN MAY96 (ED)";
label variable INSJU96X "COVRD BY HOSP/MED INS IN JUN96 (ED)";
label variable INSJL96X "COVRD BY HOSP/MED INS IN JUL96 (ED)";
label variable INSAU96X "COVRD BY HOSP/MED INS IN AUG96 (ED)";
label variable INSSE96X "COVRD BY HOSP/MED INS IN SEP96 (ED)";
label variable INSOC96X "COVRD BY HOSP/MED INS IN OCT96 (ED)";
label variable INSNO96X "COVRD BY HOSP/MED INS IN NOV96 (ED)";
label variable INSDE96X "COVRD BY HOSP/MED INS IN DEC96 (ED)";
label variable PRVEVER "EVER HAVE PRIVATE INSURANCE DURING 96";
label variable CHPEVER "EVER HAVE CHAMPUS/CHAMPVA DURING 96";
label variable MCDEVER "EVER HAVE MEDICAID DURING 96";
label variable MCREVER "EVER HAVE MEDICARE DURING 96";
label variable OPAEVER "EVER HAVE OTHER PUBLIC A INS DURING 96";
label variable OPBEVER "EVER HAVE OTHER PUBLIC B INS DURING 96";
label variable UNINSURD "UNINSURED ALL OF 96";
label variable INSCOV96 "HEALTH INSURANCE COVERAGE INDICATOR 96";
label variable PREGRD1 "ANY PREGNANCY RD 1";
label variable PREGRD2 "ANY PREGNANCY RD 2";
label variable PREGRD3 "ANY PREGNANCY RD 3";
label variable NOWPREG1 "PREGNANT AT TIME OF INTERVIEW RD 1";
label variable NOWPREG2 "PREGNANT AT TIME OF INTERVIEW RD 2";
label variable NOWPREG3 "PREGNANT AT TIME OF INTERVIEW RD 3";
label variable LIVEBIR1 "LIVE BIRTH RD 1";
label variable LIVEBIR2 "LIVE BIRTH RD 2";
label variable LIVEBIR3 "LIVE BIRTH RD 3";
label variable NUMPRG13 "NUMBER OF PREGNANCIES RDS 1-3";
label variable PREG96 "PREGNANT ANYTIME 1996";
label variable BIRTH96 "ANY LIVE BIRTH 1996";
label variable DDNOWRK1 "# DAYS MISSED WORK DUE TO ILL/INJ-R1";
label variable DDNOWRK2 "# DAYS MISSED WORK DUE TO ILL/INJ-R2";
label variable DDNOWRK3 "# DAYS MISSED WORK DUE TO ILL/INJ-R3";
label variable WRKINBD1 "# DAYS MISSED WORK STAYED IN BED-R1";
label variable WRKINBD2 "# DAYS MISSED WORK STAYED IN BED-R2";
label variable WRKINBD3 "# DAYS MISSED WORK STAYED IN BED-R3";
label variable DDNSCHL1 "# DAYS MISSED SCHOOL DUE TO ILL/INJ-R1";
label variable DDNSCHL2 "# DAYS MISSED SCHOOL DUE TO ILL/INJ-R2";
label variable DDNSCHL3 "# DAYS MISSED SCHOOL DUE TO ILL/INJ-R3";
label variable SCLINBD1 "# DAYS MISSED SCHOOL STAYED IN BED-R1";
label variable SCLINBD2 "# DAYS MISSED SCHOOL STAYED IN BED-R2";
label variable SCLINBD3 "# DAYS MISSED SCHOOL STAYED IN BED-R3";
label variable DDBEDYS1 "# OTH DAYS SPENT IN BED SINCE START-R1";
label variable DDBEDYS2 "# OTH DAYS SPENT IN BED SINCE START-R2";
label variable DDBEDYS3 "# OTH DAYS SPENT IN BED SINCE START-R3";
label variable OTHRDYS1 "MISS ANY WRK/SCH DAYS TO CARE FOR OTH-R1";
label variable OTHRDYS2 "MISS ANY WRK/SCH DAYS TO CARE FOR OTH-R2";
label variable OTHRDYS3 "MISS ANY WRK/SCH DAYS TO CARE FOR OTH-R3";
label variable OTHNMDD1 "# DAYS MISSED WRK/SCHL CARE FOR OTHRS-R1";
label variable OTHNMDD2 "# DAYS MISSED WRK/SCHL CARE FOR OTHRS-R2";
label variable OTHNMDD3 "# DAYS MISSED WRK/SCHL CARE FOR OTHRS-R3";
label variable ACCELIG2 "PERS ELIGIBLE FOR ACCESS SUPPLEMENT-R2";
label variable HAVEUSC2 "DOES PERSON HAVE A USC PROVIDER?-R2";
label variable YNOUSC2 "MAIN REASON PERS DOESN T HAVE A USC-R2";
label variable NOREAS42 "OTH REAS NO USC: NO OTH REAS (AC04)-R2";
label variable SELDSIC2 "OTH REAS NO USC: SELDOM/NEVER SICK-R2";
label variable NEWAREA2 "OTH REAS NO USC: RECENTLY MOVED-R2";
label variable DKWHRUS2 "OTH REAS NO USC: DK WHERE TO GO-R2";
label variable USCNOTA2 "OTH REAS NO USC: USC NOT AVAILABLE-R2";
label variable PERSLAN2 "OTH REAS NO USC: LANGUAGE-R2";
label variable DIFFPLA2 "OTH REAS NO USC: DIFFERENT PLACES-R2";
label variable INSRPLA2 "OTH REAS NO USC: JUST CHANGED INSUR-R2";
label variable MYSELF2 "OTH REAS NO USC: NO DOCS/TREAT SELF-R2";
label variable CARECOS2 "OTH REAS NO USC: COST OF MED CARE-R2";
label variable OTHINSR2 "OTH REAS NO USC: OTHER INSUR REASON-R2";
label variable OTHREA42 "OTH REAS NO USC: OTHER REASON (AC04)-R2";
label variable TYPEPLC2 "USC TYPE OF PLACE-R2";
label variable PROVTYX2 "PROVIDER TYPE-R2";
label variable YGOTOUS2 "MAIN REASON PERS GOES TO HOSP USC-R2";
label variable NOREAS92 "OTH REAS GO TO USC: NO OTH REAS(AC09)-R2";
label variable LIKESUS2 "OTH REAS GO TO USC: PREF/LIKES USC-R2";
label variable DKELSEW2 "OTH REAS GO TO USC: DK WH ELSE TO GO-R2";
label variable AFFORD2 "OTH REAS GO TO USC: CAN T AFFRD ELSEW-R2";
label variable OFFICE2 "OTH REAS GO TO USC: DR OFFICE AT OPD-R2";
label variable AVAILTI2 "OTH REAS GO TO USC: AVAIL WHEN TIME-R2";
label variable CONVENI2 "OTH REAS GO TO USC: CONVENIENCE-R2";
label variable BSTPLAC2 "OTH REAS GO TO USC: BEST FOR COND-R2";
label variable INSREAS2 "OTH REAS GO TO USC: INSUR-RELATED-R2";
label variable OTHREA92 "OTH REAS GO TO USC: OTH REAS (AC09)-R2";
label variable GETTOUS2 "HOW DOES PERSN GET TO USC PROVIDER-R2";
label variable TYPEPER2 "USC TYPE OF PROVIDER-R2";
label variable LOCATIO2 "USC LOCATION-R2";
label variable MINORPR2 "GO TO USC FOR NEW HEALTH PROBLEMS-R2";
label variable PREVENT2 "GO TO USC FOR PREVENTIVE HLTH CARE-R2";
label variable REFFRLS2 "GO TO USC FOR REFERRALS-R2";
label variable OFFHOUR2 "USC HAS OFFICE HRS NIGHTS/WEEKENDS-R2";
label variable APPTWLK2 "WHEN SEE USC, HAVE APPT OR WALK IN-R2";
label variable APPDIFF2 "HOW DIFFICULT TO GET APPT WITH USC-R2";
label variable WAITTIM2 "WITH APPT, HOW LONG TIL SEEN BY USC-R2";
label variable PHONEDI2 "HOW DIFFICULT CONTACT USC BY PHONE-R2";
label variable PRLISTE2 "DOES USC PROV LISTEN?-R2";
label variable TREATMN2 "PROV ASK ABOUT OTHER TREATMENTS-R2";
label variable CONFIDN2 "CONFIDENT IN USC PROV S ABILITY?-R2";
label variable PROVSTA2 "HOW SATISFIED WITH USC STAFF-R2";
label variable USCQUAL2 "SATISFIED WITH QUALITY OF CARE-R2";
label variable CHNGUSC2 "HAS ANYONE CHANG USC IN LAST YEAR-R2";
label variable YCHNGUS2 "WHY DID PERSON(S) CHANGE USC-R2";
label variable ANYUSC2 "HAS ANYONE HAD A USC IN LAST YEAR-R2";
label variable YNOMORE2 "WHY DON T THEY HAVE A USC ANYMORE?-R2";
label variable NOCARE2 "DID ANYONE GO WITHOUT HEALTH CARE-R2";
label variable HCNEEDS2 "SATISFIED FAMILY CAN GET CARE-R2";
label variable OBTAINH2 "ANYONE HAVE DIFFICLTY OBTAIN CARE-R2";
label variable MAINPRO2 "MAIN REASON EXPERIENCED DIFFICULTY-R2";
label variable NOOTHPR2 "DIFFICULTY: NO OTHER PROBLEMS-R2";
label variable NOAFFOR2 "DIFFICULTY: COULDN T AFFORD CARE-R2";
label variable INSNOPA2 "DIFFICULTY: INS COMPANY WON T PAY-R2";
label variable PREEXCO2 "DIFFICULTY: PRE-EXISTING CONDITION-R2";
label variable INSRQRE2 "DIFFICULTY: INS REQUIRED REFERRAL-R2";
label variable REFUSIN2 "DIFFICULTY: DR REFUSED INS PLAN-R2";
label variable DISTANC2 "DIFFICULTY: DISTANCE-R2";
label variable PUBTRAN2 "DIFFICULTY: PUBLIC TRANSPORTATION-R2";
label variable EXPENSI2 "DIFFICULTY: TOO EXPEN TO GET THERE-R2";
label variable HEARPRO2 "DIFFICULTY: HEARING IMPAIR/ LOSS-R2";
label variable LANGBAR2 "DIFFICULTY: LANGUAGE BARRIER-R2";
label variable INTOBLD2 "DIFFICULTY: HARD TO GET INTO BLDG-R2";
label variable INSIDE2 "DIFFICULTY: HARD TO GET AROUND-R2";
label variable EQUIPMN2 "DIFFICULTY: NO APPROPRIATE EQUIP-R2";
label variable OFFWORK2 "DIFFICULTY: COULDN T GET TIME OFF-R2";
label variable DKWHERG2 "DIFFICULTY: DK WHERE TO GO-R2";
label variable REFUSER2 "DIFFICULTY: WAS REFUSED SERVICES-R2";
label variable CHLDCAR2 "DIFFICULTY: COULDN T GET CHILD CARE-R2";
label variable NOTIME2 "DIFFICULTY: NO TIME/TOOK TOO LONG-R2";
label variable OTHRPRO2 "DIFFICULTY: OTHER-R2";
label variable RTEHLTH1 "PERCEIVED HEALTH STATUS (R1)";
label variable RTEPROX1 "SELF/PROXY RATING OF HEALTH (R1)";
label variable MNTHLTH1 "PERCEIVED MENTAL HEALTH STATUS (R1)";
label variable MNTPROX1 "SELF/PROXY RATING OF MENTAL HEALTH (R1)";
label variable IADLHLP1 "IADL SCREENER (R1)";
label variable ADLHELP1 "ADL SCREENER (R1)";
label variable AIDHELP1 "USED ASSISTIVE DEVICES (R1)";
label variable WALKLIM1 "LIMITATIONS IN PHYSICAL FUNCTIONING (R1)";
label variable LIFTDIF1 "DIFFICULTY LIFTING 10 POUNDS (R1)";
label variable STEPDIF1 "DIFFICULTY WALKING UP 10 STEPS (R1)";
label variable WALKDIF1 "DIFFICULTY WALKING 3 BLOCKS (R1)";
label variable MILEDIF1 "DIFFICULTY WALKING A MILE (R1)";
label variable STNDDIF1 "DIFFICULTY STANDING 20 MINUTES (R1)";
label variable BENDDIF1 "DIFFICULTY BENDING/STOOPING (R1)";
label variable RECHDIF1 "DIFFICULTY REACHING OVERHEAD (R1)";
label variable FINGRDF1 "DIFFICULTY USING FINGERS TO GRASP (R1)";
label variable ACTLIMT1 "ANY LIMITATION WORK/HOUSEWRK/SCHOOL (R1)";
label variable WRKLIMT1 "WORK LIMITATION (R1)";
label variable HSELIMT1 "HOUSEWORK LIMITATION (R1)";
label variable SCHLIMT1 "SCHOOL LIMITATION-R1";
label variable UNABLE1 "COMPLETELY UNABLE TO DO ACTIVITY (R1)";
label variable SOCLIMT1 "SOCIAL LIMITATIONS (R1)";
label variable COGLIMT1 "COGNITIVE LIMITATIONS (R1)";
label variable HSELIG2 "IS PERS ELIGIBLE FOR HS SUPPLEMENT-R2";
label variable RTEHLTH2 "PERCEIVED HEALTH STATUS (R2)";
label variable RTEPROX2 "SELF/PROXY RATING OF HEALTH (R2)";
label variable MNTHLTH2 "PERCEIVED MENTAL HEALTH STATUS (R2)";
label variable MNTPROX2 "SELF/PROXY RATING OF MENTAL HEALTH (R2)";
label variable IADLHLP2 "IADL SCREENER (R2)";
label variable ADLHELP2 "ADL SCREENER (R2)";
label variable WEARGLA2 "WEARS EYEGLASSES OR CONTACTS-R2";
label variable SEEDIF2 "DIFFIC SEEING (W/GLASSES/CONTACTS)-R2";
label variable BLIND2 "PERSON IS BLIND-R2";
label variable READNEW2 "CAN READ NEWSPR (W/GLASSES/CONTACTS)-R2";
label variable RECPEOP2 "CAN RECOG PEOPLE(W/GLASSES/CONTACTS)-R2";
label variable VISION2 "VISION IMPAIRMENT (SUMMARY)-R2";
label variable HEARAID2 "PERSON WEARS HEARING AID-R2";
label variable HEARDIF2 "ANY DIFFIC HEARING (W/HEARING AID)-R2";
label variable DEAF2 "PERSON IS DEAF-R2";
label variable HEARMOS2 "CAN HEAR MOST CONVERSATION-R2";
label variable HEARSOM2 "CAN HEAR SOME CONVERSATION-R2";
label variable HEARING2 "HEARING IMPAIRMENT (SUMMARY)-R2";
label variable ANYLIM12 "ANY LIMITATION: R1 & R2";
label variable LIMACT2 "LIMITED IN ANY ACTIV (<5 YEARS)-R2";
label variable PLAYLIM2 "LIMITED IN PLAY ACTIV (<5 YEARS)-R2";
label variable CANTPLA2 "CANT PARTICIP IN USUAL PLAY (<5 YR)-R2";
label variable SPECPRO2 "IN SPECIAL PROGRAM (<5 YEARS)-R2";
label variable DTPSHOT2 "IMMUNIZATION FOR DTP (<7 YEARS)-R2";
label variable NUMDTP2 "ONE OR SEVERAL DTP SHOTS (<7 YEARS-R2)";
label variable POLIOSH2 "IMMUNIZATION FOR POLIO (<7 YEARS)-R2";
label variable NUMPOLI2 "ONE OR SEVERAL POLIO SHOTS (<7 YEARS)-R2";
label variable MMRSHOT2 "IMMUNIZ FOR MEASLES/MUMPS/RUBELLA-R2";
label variable HEPBSHT2 "IMMUNIZ FOR HEPATITIS (<7 YEARS)-R2";
label variable MOMPROB2 "PROB GETTING ALONG WITH MOTHER (5-17)-R2";
label variable DADPROB2 "PROB GETTING ALONG WITH FATHER (5-17)-R2";
label variable UNHAP2 "PROB FEELING UNHAPPY OR SAD (5-17)-R2";
label variable SCHLBEH2 "PROB BEHAVIOR AT SCHOOL (5-17)-R2";
label variable HAVEFUN2 "PROB HAVING FUN (5-17)-R2";
label variable ADULPRO2 "PROB GETTING ALONG W/ADULTS (5-17)-R2";
label variable NERVAFR2 "PROB FEELING NERVOUS/AFRAID (5-17)-R2";
label variable SIBPROB2 "PROB GETTING ALONG WITH SIBS (5-17)-R2";
label variable KIDPROB2 "PROB GETTING ALONG W/KIDS (5-17)-R2";
label variable SPORPRO2 "PROB WITH SPORTS/HOBBIES (5-17)-R2";
label variable SCHLPRO2 "PROB WITH SCHOOLWORK (5-17)-R2";
label variable HOMEBEH2 "PROB WITH BEHAVIOR AT HOME (5-17)-R2";
label variable TROUBLE2 "PROB STAYING OUT OF TROUBLE-R2";
label variable SPECSCH2 "NEED SPEC SCHOOL PROGRAM (5-17)-R2";
label variable SPECED2 "IN SPECIAL EDUCATION (5-17)-R2";
label variable PROGTXT2 "DESCRIP OF SPEC ED PROGRM (5-17 YRS)-R2";
label variable SPCHTHE2 "RECEIVED SPEECH THERAPY (5-17)-R2";
label variable PSYCNSL2 "PSYCHOLOGICAL COUNSELING-R2";
label variable OCUPTHE2 "RECEIVD OCCUPATIONAL THERAPY (5-17)-R2";
label variable VOCSVCS2 "RECEIVED VOCATIONAL SERVICES (5-17)-R2";
label variable TUTOR2 "RECEIVED TUTORING (5-17)-R2";
label variable READINT2 "USES READER OR INTERPRETER (5-17)-R2";
label variable PHYTHER2 "RECEIVED PHYSICAL THERAPY (5-17)-R2";
label variable LIFSKIL2 "RECEIVD LIFE SKILLS TRAINING (5-17)-R2";
label variable FAMCNS2 "RECEIVED FAMILY COUNSELING (5-17)-R2";
label variable RECTHER2 "RECEIVD RECREATIONAL THERAPY (5-17)-R2";
label variable OTHSVC2 "RECEIVD OTHER SCHOOL SERVICES (5-17)-R2";
label variable CANTSCH2 "LIMITED/UNABLE GO TO SCHOOL (5-17)-R2";
label variable LMOTACT2 "LIMITED NON-SCHOOL ACTIVITY (5-17)-R2";
label variable SPECIFL2 "WHAT TYPE OF LIMITATION (5-17 YRS)-R2";
label variable HEALTHY2 "CHILD RESISTS ILLNESS WELL (0-17)-R2";
label variable NTHLTHY2 "LESS HEALTHY SAME AGE KIDS (0-17)-R2";
label variable GETSICK2 "CATCHES THINGS GOING AROUND (0-17)-R2";
label variable HIGHTFT2 "CHILD S HEIGHT - FEET (0-17)-R2";
label variable HIGHTIN2 "CHILD S HEIGHT - INCHES (0-17)-R2";
label variable WEIGHLB2 "CHILD S WEIGHT - POUNDS (0-17)-R2";
label variable WEIGHOZ2 "CHILD S WEIGHT - OUNCES (0-17)-R2";
label variable CHLDLIM2 "CHILD HAS ANY LIMITATION (0-17)-R2";
label variable ALTCAR96 "ANY ALTERNATIVE CARE USE  96";
label variable ACUPUN96 "PERSON RECEIVED ACUPUNCTURE  96";
label variable NUTRIT96 "PERSON RECEIVED NUTRITIONAL ADVICE  96";
label variable MASSAG96 "PERSON RECEIVED MASSAGE THERAPY   96";
label variable HERBAL96 "PERSON PURCHASED HERBAL REMEDIES  96";
label variable BIOFDB96 "PERSON RECEIVED BIOFEEDBACK  96";
label variable MEDITA96 "PERSON RECEIVED MEDITATION TRAINING  96";
label variable HOMEOT96 "PERSON RECEIVED HOMEOPATHIC THERAPY  96";
label variable SPIRTU96 "PERSON RECEIVED SPIRITUAL HEALING  96";
label variable HYPNO96 "PERSON RECEIVED HYPNOSIS  96";
label variable TRADIT96 "PERSON RECEIVED TRADITIONAL MEDICINE  96";
label variable ALTOTH96 "PERSON RECEIVED OTHER ALTERNATIVE TX  96";
label variable MASSTH96 "PERSON SAW MASSAGE THERAPIST  96";
label variable ACUPTH96 "PERSON SAW ACUPUNCTURIST  96";
label variable MDTREA96 "PER SAW PHYSICIAN FOR ALTERNATIVE TX  96";
label variable NURTRT96 "PERSON SAW NURSE FOR ALTERNATIVE TX  96";
label variable HOMEOM96 "PERS SAW HOMEOPATHIC/NATUROPATHIC DOC 96";
label variable CHIRO96 "PERSON SAW CHIROPRACTOR  96";
label variable CLERGY96 "PERSON SAW CLERGY OR SPIRITUALIST  96";
label variable HERBTR96 "PERSON SAW HERBALIST  96";
label variable OTHALT96 "PERS SAW OTH PRACTITIONER FOR ALT TX  96";
label variable ALCRVS96 "NUM OF VISITS TO ALTERNATIVE CARE  96";
label variable ALCRVE96 "ESTIMATED NUMBER OF ALT TX VISITS  96";
label variable ALCRSP96 "USED ALT CARE FOR SPECIFIC HLTH PROB  96";
label variable DISCAL96 "DISCUSSED ALT CARE WITH REGULAR MD  96";
label variable REFRMD96 "REFERRED BY PHYSICIAN FOR ALT TX  96";
label variable ALCREE96 "ESTIM TOTAL AMT SPENT FOR ALT CARE 96";
label variable ALCREX96 "RANGE OF AMOUNT SPENT 96";
label variable INSALT96 "DID INSURANCE PAY FOR ALT CARE 96";
label variable PERCIN96 "EST PCNT PAID BY INSUR FOR ALT CARE 96";
label variable PALTEX96 "TOTAL SPENT ON ALT CARE REMEDIES 96";
label variable PALTEE96 "RANGE SPENT ON ALT REMEDIES 96";
label variable DENTCHK3 "DENTAL CHECKUP FREQUENCY";
label variable BLDPCHK3 "TIME SINCE BLOOD PRESSURE CHECK";
label variable CHOLCHK3 "TIME SINCE CHOLESTEROL CHECK";
label variable PHYSICL3 "TIME SINCE COMPLETE PHYSICAL";
label variable FLUSHOT3 "TIME SINCE FLU SHOT";
label variable WEARDEN3 "PERSON WEARS DENTURES";
label variable LOSTEET3 "PERSON LOST ALL ADULT TEETH";
label variable PROSEXA3 "TIME SINCE PROSTATE EXAM";
label variable PAPSMER3 "TIME SINCE PAP SMEAR";
label variable BRSTEXA3 "TIME SINCE BREAST EXAM";
label variable MAMOGRM3 "TIME SINCE MAMMOGRAM";
label variable TOTTCH96 "TOTAL HEALTH CARE CHARGES 96, EXCL. RX";
label variable TOTEXP96 "TOTAL HEALTH CARE EXP 96";
label variable TOTSLF96 "TOTAL AMT PAID BY SELF/FAMILY 96";
label variable TOTMCR96 "TOTAL AMT PAID BY MEDICARE 96";
label variable TOTMCD96 "TOTAL AMT PAID BY MEDICAID 96";
label variable TOTPRV96 "TOTAL AMT PAID BY PRIVATE INS 96";
label variable TOTVA96 "TOTL AMT PAID BY VA 96";
label variable TOTCHM96 "TOTL AMT PAID BY CHAMPUS/CHAMPVA 96";
label variable TOTOFD96 "TOTL AMT PAID BY OTHER FEDERAL 96";
label variable TOTSTL96 "TOTL AMT PAID BY OTH ST/LOCAL 96";
label variable TOTWCP96 "TOTL AMT PAID BY WORKERS COMP 96";
label variable TOTOPR96 "TOTL AMT PAID BY OTHER PRIVATE 96";
label variable TOTOPU96 "TOTL AMT PAID BY OTHER PUBLIC 96";
label variable TOTOSR96 "TOTL AMT PAID BY OTHER SOURCES 96";
label variable OBTOTV96 "# OFFICE-BASED PROVIDER VISITS 96";
label variable OBVTCH96 "OFFICE-BASED PROVIDER VISIT CHARGES 96";
label variable OBVEXP96 "TOTAL OFFICE-BASED EXP 96";
label variable OBVSLF96 "ALL OFFICE VISITS -SELF/FAMILY AMT 96";
label variable OBVMCR96 "ALL OFFICE VISITS -MEDICARE AMT 96";
label variable OBVMCD96 "ALL OFFICE VISITS -MEDICAID AMT 96";
label variable OBVPRV96 "ALL OFFICE VISITS -PRIVATE INS AMT 96";
label variable OBVVA96 "ALL OFFICE VISITS-VA AMT 96";
label variable OBVCHM96 "ALL OFFICE VISITS-CHAMPUS/CHAMPVA AMT 96";
label variable OBVOFD96 "ALL OFFICE VISITS-OTHER FEDERAL AMT 96";
label variable OBVSTL96 "ALL OFFICE VISITS-OTH ST/LOCAL AMT 96";
label variable OBVWCP96 "ALL OFFICE VISITS -WORKERS COMP AMT 96";
label variable OBVOPR96 "ALL OFFICE VISITS - OTH PRIVATE AMT 96";
label variable OBVOPU96 "ALL OFFICE VISITS - OTH PUBLIC AMT 96";
label variable OBVOSR96 "ALL OFF VSTS - OTH UNCLASS SRCE AMT 96";
label variable OBDRV96 "# OFFICE-BASED PHYSICIAN VISITS 96";
label variable OBDTCH96 "OFFICE-BASED PHYSICIAN VISIT CHARGES 96";
label variable OBDEXP96 "TOTAL OFF-BASED DR EXP 96";
label variable OBDSLF96 "DR OFFICE VISITS -SELF/FAMILY AMT 96";
label variable OBDMCR96 "DR OFFICE VISITS -MEDICARE AMT 96";
label variable OBDMCD96 "DR OFFICE VISITS -MEDICAID AMT 96";
label variable OBDPRV96 "DR OFFICE VISITS -PRIVATE INS AMT 96";
label variable OBDVA96 "DR OFFICE VISITS -VA AMT 96";
label variable OBDCHM96 "DR OFFICE VISITS-CHAMPUS/CHAMPVA AMT 96";
label variable OBDOFD96 "DR OFFICE VISITS -OTHER FEDERAL AMT 96";
label variable OBDSTL96 "DR OFFICE VISITS -OTH ST/LOCAL AMT 96";
label variable OBDWCP96 "DR OFFICE VISITS -WORKERS COMP AMT 96";
label variable OBDOPR96 "DR OFFICE VISITS - OTH PRIVATE AMT 96";
label variable OBDOPU96 "DR OFFICE VISITS - OTH PUBLIC AMT 96";
label variable OBDOSR96 "DR OFF VSTS - OTH UNCLASS SRCE AMT 96";
label variable OBOTHV96 "# OFFICE-BASED NON-PHYSICAN VISITS 96";
label variable OBOTCH96 "OFFICE-BASED NON-DR VISIT CHARGES 96";
label variable OBOEXP96 "TOTAL OFF-BASED NON-DR EXP 96";
label variable OBOSLF96 "NON-DR OFF VISTS -SELF/FAMILY AMT 96";
label variable OBOMCR96 "NON-DR OFF VISTS -MEDICARE AMT 96";
label variable OBOMCD96 "NON-DR OFF VISTS -MEDICAID AMT 96";
label variable OBOPRV96 "NON-DR OFF VISTS -PRIVATE INS AMT 96";
label variable OBOVA96 "NON-DR OFF VISTS -VA AMT 96";
label variable OBOCHM96 "NON-DR OFF VISTS-CHAMPUS/CHAMPVA AMT 96";
label variable OBOOFD96 "NON-DR OFF VISTS -OTHER FEDERAL AMT 96";
label variable OBOSTL96 "NON-DR OFF VISTS -OTH ST/LOCAL AMT 96";
label variable OBOWCP96 "NON-DR OFF VISTS -WORKERS COMP AMT 96";
label variable OBOOPR96 "NON-DR OFF VISTS - OTH PRIVATE AMT 96";
label variable OBOOPU96 "NON-DR OFF VISTS - OTH PUBLIC AMT 96";
label variable OBOOSR96 "NON-DR OF VSTS - OTH UNCLASS SRCE AMT 96";
label variable OBCHIR96 "# OFFICE-BASED CHIROPRACTOR VISITS 96";
label variable OBCTCH96 "OFFICE-BASED CHIRO VISIT CHARGES 96";
label variable OBCEXP96 "TOTAL OFF-BASED CHIRO EXP 96";
label variable OBCSLF96 "CHIRO OFF VISITS -SELF/FAMILY AMT 96";
label variable OBCMCR96 "CHIRO OFF VISITS -MEDICARE AMT 96";
label variable OBCMCD96 "CHIRO OFF VISITS -MEDICAID AMT 96";
label variable OBCPRV96 "CHIRO OFF VISITS -PRIVATE INS AMT 96";
label variable OBCVA96 "CHIRO OFF VISITS -VA AMT 96";
label variable OBCCHM96 "CHIRO OFF VISITS-CHAMPUS/CHAMPVA AMT 96";
label variable OBCOFD96 "CHIRO OFF VISITS -OTHER FEDERAL AMT 96";
label variable OBCSTL96 "CHIRO OFF VISITS -OTH ST/LOCAL AMT 96";
label variable OBCWCP96 "CHIRO OFF VISITS -WORKERS COMP AMT 96";
label variable OBCOPR96 "CHIRO OFF VISTS - OTHR PRIVATE AMT 96";
label variable OBCOPU96 "CHIRO OFF VISTS - OTHR PUBLIC AMT 96";
label variable OBCOSR96 "CHIRO OF VSTS - OTHR UNCLASS SRCE AMT 96";
label variable OBNURS96 "# OFF-BASED NURSE/PRACTITIONER VISITS 96";
label variable OBNTCH96 "OFFICE-BASED NURSE/PRAC VISIT CHARGES 96";
label variable OBNEXP96 "TOTAL OFF-BASED NURSE/PRAC 96";
label variable OBNSLF96 "NURSE/PRAC OFF VISITS-SELF/FAMILY AMT 96";
label variable OBNMCR96 "NURSE/PRAC OFF VISITS -MEDICARE AMT 96";
label variable OBNMCD96 "NURSE/PRAC OFF VSTS -MEDICAID AMT 96";
label variable OBNPRV96 "NURSE/PRAC OFF VSTS -PRIVATE INS AMT 96";
label variable OBNVA96 "NURSE/PRAC OFF VSTS-VA AMT 96";
label variable OBNCHM96 "NURSE/PRAC OFF VSTS-CHMPUS/CHMPVA AMT 96";
label variable OBNOFD96 "NURSE/PRAC OFF VSTS-OTHER FEDERAL AMT 96";
label variable OBNSTL96 "NURSE/PRAC OFF VSTS -OTH ST/LOCAL AMT 96";
label variable OBNWCP96 "NURSE/PRAC OFF VSTS -WORKERS COMP AMT 96";
label variable OBNOPR96 "NURSE/PRAC OFF VSTS - OTH PRIVATE AMT 96";
label variable OBNOPU96 "NURSE/PRAC OFF VSTS - OTH PUBLIC AMT 96";
label variable OBNOSR96 "NRS/PR OF VSTS - OTH UNCLASS SRCE AMT 96";
label variable OBOPTO96 "# OFF-BASED OPTOMETRIST VISITS 96";
label variable OBETCH96 "OFFICE-BASED OPTOMTRIST VISIT CHARGES 96";
label variable OBEEXP96 "TOTAL OFF-BASED OPOTMETRIST EXP 96";
label variable OBESLF96 "OPTOMETRIST OFF VSTS -SELF/FAMILY AMT 96";
label variable OBEMCR96 "OPTOMETRIST OFF VSTS -MEDICARE AMT 96";
label variable OBEMCD96 "OPTOMETRIST OFF VSTS -MEDICAID AMT 96";
label variable OBEPRV96 "OPTOMETRIST OFF VSTS -PRIVATE INS AMT 96";
label variable OBEVA96 "OPTOMETRIST OFF VSTS -VA AMT 96";
label variable OBECHM96 "OPTOMETRIST OFF VSTS-CHMPUS/CHPVA AMT 96";
label variable OBEOFD96 "OPTOMETRIST OFF VSTS-OTH FEDERAL AMT 96";
label variable OBESTL96 "OPTOMETRIST OFF VSTS -OTH ST/LOCL AMT 96";
label variable OBEWCP96 "OPTOMETRIST OFF VSTS-WORKERS COMP AMT 96";
label variable OBEOPR96 "OPTOMETRIST OFF VSTS -OTH PRIVATE AMT 96";
label variable OBEOPU96 "OPTOMETRIST OFF VSTS -OTH PUBLIC AMT 96";
label variable OBEOSR96 "OPTOM OF VSTS - OTH UNCLASS SRCE AMT 96";
label variable OBASST96 "# OFF-BASED PHYSICIAN ASSIST VISITS 96";
label variable OBATCH96 "OFFICE-BASED PHYS ASST VISIT CHARGES 96";
label variable OBAEXP96 "TOTAL OFF-BASED PHYS ASS T EXP 96";
label variable OBASLF96 "PHYS ASS T OFF VSTS-SELF/FAMILY AMT 96";
label variable OBAMCR96 "PHYS ASS T OFF VSTS-MEDICARE AMT 96";
label variable OBAMCD96 "PHYS ASS T OFF VSTS-MEDICAID AMT 96";
label variable OBAPRV96 "PHYS ASS T OFF VSTS-PRIVATE INS AMT 96";
label variable OBAVA96 "PHYS ASS T OFF VSTS-VA AMT 96";
label variable OBACHM96 "PHYS ASS T OFF VSTS-CHMPUS/CHMPVA AMT 96";
label variable OBAOFD96 "PHYS ASS T OFF VSTS -OTHER FED AMT 96";
label variable OBASTL96 "PHYS ASS T OFF VSTS -OTH ST/LOCL AMT 96";
label variable OBAWCP96 "PHYS ASS T OFF VSTS-WORKERS COMP AMT 96";
label variable OBAOPR96 "PHYS ASS T OFF VSTS - OTH PRIVATE AMT 96";
label variable OBAOPU96 "PHYS ASS T OFF VSTS - OTH PUBLIC AMT 96";
label variable OBAOSR96 "P A OFF VSTS - OTH UNCLASS SRCE AMT 96";
label variable OBTHER96 "# OFF-BASED PT/OT VISITS 96";
label variable OBTTCH96 "OFFICE-BASED PT/OC VISIT CHARGES 96";
label variable OBTEXP96 "TOT OFF-BASED PT EXP 96";
label variable OBTSLF96 "PT/OT OFF VISITS-SELF/FAMILY AMT 96";
label variable OBTMCR96 "PT/OT OFF VISITS-MEDICARE AMT 96";
label variable OBTMCD96 "PT/OT OFF VISITS-MEDICAID AMT 96";
label variable OBTPRV96 "PT/OT OFF VISITS-PRIVATE INS AMT 96";
label variable OBTVA96 "PT/OT OFF VISITS-VA AMT 96";
label variable OBTCHM96 "PT/OT OFF VISITS-CHAMPUS/CHAMPVA AMT 96";
label variable OBTOFD96 "PT/OT OFF VISITS -OTHER FED AMT 96";
label variable OBTSTL96 "PT/OT OFF VISITS-OTH ST/LOCL AMT 96";
label variable OBTWCP96 "PT/OT OFF VISITS-WORKERS COMP AMT 96";
label variable OBTOPR96 "PT/OT OFF VISITS - OTH PRIVATE AMT 96";
label variable OBTOPU96 "PT/OT OFF VISITS - OTH PUBLIC AMT 96";
label variable OBTOSR96 "PT/OT OF VSTS-OTH UNCLASS SRCE AMT 96";
label variable OPTOTV96 "# OUTPATIENT DEPT PROVIDER VISITS 96";
label variable OPFTCH96 "OPD PROVIDER VISIT CHARGES - FAC 96";
label variable OPFEXP96 "TOTAL OUTPATIENT FACILITY EXP 96";
label variable OPFSLF96 "ALL OPD VISITS-SELF/FAMILY AMT-FAC 96";
label variable OPFMCR96 "ALL OPD VISITS-MEDICARE AMT-FAC 96";
label variable OPFMCD96 "ALL OPD VISITS-MEDICAID AMT-FAC 96";
label variable OPFPRV96 "ALL OPD VISITS-PRIV INS AMT-FAC 96";
label variable OPFVA96 "ALL OPD VISITS-VA AMT-FAC 96";
label variable OPFCHM96 "ALL OPD VISITS-CHMPUS/CHMPVA AMT-FAC 96";
label variable OPFOFD96 "ALL OPD VISITS-OTHER FED AMT-FAC 96";
label variable OPFSTL96 "ALL OPD VISITS-OTH ST/LOCAL AMT-FAC 96";
label variable OPFWCP96 "ALL OPD VISITS-WORKERS COMP AMT-FAC 96";
label variable OPFOPR96 "ALL OPD VISITS - OTH PRIVATE AMT-FAC 96";
label variable OPFOPU96 "ALL OPD VISITS - OTH PUBLIC AMT-FAC 96";
label variable OPFOSR96 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-FAC 96";
label variable OPDEXP96 "TOTAL OUTPATIENT PROVIDER EXP 96";
label variable OPDTCH96 "OPD PROVIDER VISIT CHARGES - DR 96";
label variable OPDSLF96 "ALL OPD VISITS-SELF/FAMILY AMT-DR 96";
label variable OPDMCR96 "ALL OPD VISITS-MEDICARE AMT -DR 96";
label variable OPDMCD96 "ALL OPD VISITS-MEDICAID AMT -DR 96";
label variable OPDPRV96 "ALL OPD VISITS-PRIV INS AMT-DR 96";
label variable OPDVA96 "ALL OPD VISITS-VA AMT-DR 96";
label variable OPDCHM96 "ALL OPD VISITS-CHMPUS/CHMPVA AMT-DR 96";
label variable OPDOFD96 "ALL OPD VISITS-OTHER FED AMT-DR 96";
label variable OPDSTL96 "ALL OPD VISITS-OTH ST/LOCAL AMT-DR 96";
label variable OPDWCP96 "ALL OPD VISITS-WORKERS COMP AMT-DR 96";
label variable OPDOPR96 "ALL OPD VISITS - OTH PRIVATE AMT-DR 96";
label variable OPDOPU96 "ALL OPD VISITS-OTH PUBLIC AMT-DR 96";
label variable OPDOSR96 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-DR 96";
label variable OPDRV96 "# OUTPATIENT DEPT PHYSICIAN VISITS 96";
label variable OPVTCH96 "OPD PHYSICIAN VISIT CHARGES - FAC 96";
label variable OPVEXP96 "TOTAL OUTPATIENT PHYSICIAN - FAC EXP 96";
label variable OPVSLF96 "OPD DR VISITS-SELF/FAMILY AMT-FAC 96";
label variable OPVMCR96 "OPD DR VISITS-MEDICARE AMT-FAC 96";
label variable OPVMCD96 "OPD DR VISITS-MEDICAID AMT-FAC 96";
label variable OPVPRV96 "OPD DR VISITS-PRIV INS AMT-FAC 96";
label variable OPVVA96 "OPD DR VISITS-VA AMT-FAC 96";
label variable OPVCHM96 "OPD DR VISITS-CHPUS/CHPVA AMT-FAC 96";
label variable OPVOFD96 "OPD DR VISITS-OTHER FED AMT-FAC 96";
label variable OPVSTL96 "OPD DR VISITS-OTH ST/LOCAL AMT-FAC 96";
label variable OPVWCP96 "OPD DR VISITS-WORKERS COMP AMT-FAC 96";
label variable OPVOPR96 "OPD DR VISITS - OTH PRIVATE AMT-FAC 96";
label variable OPVOPU96 "OPD DR VISITS-OTH PUBLIC AMT-FAC 96";
label variable OPVOSR96 "OPD DR VSTS-OTH UNCLASS SRCE AMT-FAC 96";
label variable OPSEXP96 "TOTAL OUTPATIENT PHYSICIAN - DR EXP 96";
label variable OPSTCH96 "OPD PHYSICIAN VISIT CHARGES - DR 96";
label variable OPSSLF96 "OPD DR VISITS-SELF/FAMILY AMT-DR 96";
label variable OPSMCR96 "OPD DR VISITS-MEDICARE AMT-DR 96";
label variable OPSMCD96 "OPD DR VISITS-MEDICAID AMT-DR 96";
label variable OPSPRV96 "OPD DR VISITS-PRIV INS AMT-DR 96";
label variable OPSVA96 "OPD DR VISITS-VA AMT-DR 96";
label variable OPSCHM96 "OPD DR VISITS-CHMPUS/CHMPVA AMT-DR 96";
label variable OPSOFD96 "OPD DR VISITS-OTHER FED AMT-DR 96";
label variable OPSSTL96 "OPD DR VISITS-OTH ST/LOCAL AMT-DR 96";
label variable OPSWCP96 "OPD DR VISITS-WORKERS COMP AMT-DR 96";
label variable OPSOPR96 "OPD DR VISITS - OTH PRIVATE AMT-DR 96";
label variable OPSOPU96 "OPD DR VISITS-OTH PUBLIC AMT-DR 96";
label variable OPSOSR96 "OPD DR VSTS-OTH UNCLASS SRCE AMT-DR 96";
label variable OPOTHV96 "# OUTPATIENT DEPT NON-DR VISITS 96";
label variable OPOTCH96 "OPD NON-PHYS VISIT CHARGES - FAC 96";
label variable OPOEXP96 "TOTAL OUTPATIENT NON-DR - FAC EXP 96";
label variable OPOSLF96 "OPD NON-DR VISITS-SELF/FAM AMT-FAC 96";
label variable OPOMCR96 "OPD NON-DR VISITS-MEDICARE AMT-FAC 96";
label variable OPOMCD96 "OPD NON-DR VISITS-MEDICAID AMT-FAC 96";
label variable OPOPRV96 "OPD NON-DR VISITS-PRIV INS AMT-FAC 96";
label variable OPOVA96 "OPD NON-DR VISITS-VA AMT-FAC 96";
label variable OPOCHM96 "OPD NON-DR VISITS-CHPS/CHVA AMT-FAC 96";
label variable OPOOFD96 "OPD NON-DR VISITS-OTHER FED AMT-FAC 96";
label variable OPOSTL96 "OPD NON-DR VISITS-OTH ST/LOC AMT-FAC 96";
label variable OPOWCP96 "OPD NON-DR VISITS-WRKRS COMP AMT-FAC 96";
label variable OPOOPR96 "OPD NON-DR VISITS-OTH PRIVATE AMT-FAC 96";
label variable OPOOPU96 "OPD NON-DR VISITS-OTH PUBLIC AMT-FAC 96";
label variable OPOOSR96 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-FAC 96";
label variable OPPEXP96 "TOTAL OUTPATIENT NON-DR - DR EXP 96";
label variable OPPTCH96 "OPD NON-PHYS VISIT CHARGES - DR 96";
label variable OPPSLF96 "OPD NON-DR VISITS-SELF/FAM AMT-DR 96";
label variable OPPMCR96 "OPD NON-DR VISITS-MEDICARE AMT-DR 96";
label variable OPPMCD96 "OPD NON-DR VISITS-MEDICAID AMT-DR 96";
label variable OPPPRV96 "OPD NON-DR VISITS-PRIV INS AMT-DR 96";
label variable OPPVA96 "OPD NON-DR VISITS-VA AMT-DR 96";
label variable OPPCHM96 "OPD NON-DR VISITS-CHPS/CHVA AMT-DR 96";
label variable OPPOFD96 "OPD NON-DR VISITS-OTHER FED AMT-DR 96";
label variable OPPSTL96 "OPD NON-DR VISITS-OTH ST/LOC AMT-DR 96";
label variable OPPWCP96 "OPD NON-DR VISITS-WRKRS COMP AMT-DR 96";
label variable OPPOPR96 "OPD NON-DR VISITS-OTH PRIVATE AMT-DR 96";
label variable OPPOPU96 "OPD NON-DR VISITS-OTH PUBLIC AMT-DR 96";
label variable OPPOSR96 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-DR 96";
label variable ERTOT96 "# EMERGENCY ROOM VISITS 96";
label variable ERFTCH96 "ER FACILITY VISIT CHARGES 96";
label variable ERFEXP96 "TOTAL ER FACILITY EXP 96";
label variable ERFSLF96 "ER-SELF/FAMILY AMT - FAC 96";
label variable ERFMCR96 "ER-MEDICARE AMT - FAC 96";
label variable ERFMCD96 "ER-MEDICAID AMT - FAC 96";
label variable ERFPRV96 "ER-PRIVATE INS AMT - FAC 96";
label variable ERFVA96 "ER-VA AMT - FAC 96";
label variable ERFCHM96 "ER-CHAMPUS/CHAMPVA AMT - FAC 96";
label variable ERFOFD96 "ER-OTHER FEDERAL AMT - FAC 96";
label variable ERFSTL96 "ER-OTH ST/LOCAL AMT - FAC 96";
label variable ERFWCP96 "ER-WORKERS COMP AMT - FAC 96";
label variable ERFOPR96 "ER-OTHER PRIVATE AMT - FAC 96";
label variable ERFOPU96 "ER-OTHER PUBLIC AMT - FAC 96";
label variable ERFOSR96 "ER-OTH UNCLASS SRCE AMT - FAC 96";
label variable ERDEXP96 "TOTAL EMERGENCY ROOM DR EXP 96";
label variable ERDTCH96 "ER DOCTOR VISIT CHARGES 96";
label variable ERDSLF96 "ER-SELF/FAMILY AMT - DR 96";
label variable ERDMCR96 "ER-MEDICARE AMT - DR 96";
label variable ERDMCD96 "ER-MEDICAID AMT - DR 96";
label variable ERDPRV96 "ER-PRIVATE INS AMT - DR 96";
label variable ERDVA96 "ER-VA AMT - DR 96";
label variable ERDCHM96 "ER-CHAMPUS/CHAMPVA AMT - DR 96";
label variable ERDOFD96 "ER-OTHER FED AMT - DR 96";
label variable ERDSTL96 "ER-OTH ST/LOCAL AMT - DR 96";
label variable ERDWCP96 "ER-WORKERS COMP AMT - DR 96";
label variable ERDOPR96 "ER - OTHER PRIVATE AMT - DR 96";
label variable ERDOPU96 "ER - OTHER PUBLIC AMT - DR 96";
label variable ERDOSR96 "ER-OTH UNCLASS SRCE AMT - DR 96";
label variable IPZERO96 "# ZERO-NIGHT HOSPITAL STAYS 96";
label variable ZIFTCH96 "ZERO-NITE IP STAY CHARGES - FAC 96";
label variable ZIFEXP96 "TOTAL ZERO-NITE STAYS FAC EXP 96";
label variable ZIFSLF96 "ZERO-NITE IP STAZ -SELF/FAM AMT-FAC 96";
label variable ZIFMCR96 "ZERO-NITE IP STAZ-MEDICARE AMT-FAC 96";
label variable ZIFMCD96 "ZERO-NITE IP STAZ-MEDICAID AMT-FAC 96";
label variable ZIFPRV96 "ZERO-NITE IP STAZ-PRIV INS AMT-FAC 96";
label variable ZIFVA96 "ZERO-NITE IP STAZ-VA AMT-FAC 96";
label variable ZIFCHM96 "ZERO-NITE IP STAZ-CHPUS/CHPVA AMT-FAC 96";
label variable ZIFOFD96 "ZERO-NITE IP STAZ-OTHER FED AMT-FAC 96";
label variable ZIFSTL96 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-FAC 96";
label variable ZIFWCP96 "ZERO-NITE IP STAZ-WRKERS COMP AMT-FAC 96";
label variable ZIFOPR96 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-FAC 96";
label variable ZIFOPU96 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-FAC 96";
label variable ZIFOSR96 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-FAC 96";
label variable ZIDEXP96 "TOTAL ZERO-NITE STAZ DR 96";
label variable ZIDTCH96 "ZERO-NITE IP STAY CHARGES - DR 96";
label variable ZIDSLF96 "ZERO-NITE IP STAZ-SELF/FAM AMT-DR 96";
label variable ZIDMCR96 "ZERO-NITE IP STAZ-MEDICARE AMT-DR 96";
label variable ZIDMCD96 "ZERO-NITE IP STAZ-MEDICAID AMT-DR 96";
label variable ZIDPRV96 "ZERO-NITE IP STAZ-PRIV INS AMT-DR 96";
label variable ZIDVA96 "ZERO-NITE IP STAZ-VA AMT-DR 96";
label variable ZIDCHM96 "ZERO-NITE IP STAZ-CHPUS/CHPVA AMT-DR 96";
label variable ZIDOFD96 "ZERO-NITE IP STAZ-OTHER FED AMT-DR 96";
label variable ZIDSTL96 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-DR 96";
label variable ZIDWCP96 "ZERO-NITE IP STAZ-WRKERS COMP AMT-DR 96";
label variable ZIDOPR96 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-DR 96";
label variable ZIDOPU96 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-DR 96";
label variable ZIDOSR96 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-DR 96";
label variable IPDIS96 "# HOSPITAL DISCHARGES, 1996";
label variable IPFEXP96 "TOT HOSP IP FACILITY EXP-INC 0 NITES 96";
label variable IPFTCH96 "IP HOSP STAY CHARGES - FAC 96";
label variable IPFSLF96 "IP HOSP STAZ-SELF/FAMILY AMT-FAC 96";
label variable IPFMCR96 "IP HOSP STAZ-MEDICARE AMT-FAC 96";
label variable IPFMCD96 "IP HOSP STAZ-MEDICAID AMT-FAC 96";
label variable IPFPRV96 "IP HOSP STAZ-PRIV INS AMT-FAC 96";
label variable IPFVA96 "IP HOSP STAZ-VA AMT-FAC 96";
label variable IPFCHM96 "IP HOSP STAZ-CHAMPUS/CHAMPVA AMT-FAC 96";
label variable IPFOFD96 "IP HOSP STAZ-OTHER FED AMT-FAC 96";
label variable IPFSTL96 "IP HOSP STAZ-OTH ST/LOCAL AMT-FAC 96";
label variable IPFWCP96 "IP HOSP STAZ-WORKERS COMP AMT-FAC 96";
label variable IPFOPR96 "IP HOSP STAZ - OTH PRIVATE AMT-FAC 96";
label variable IPFOPU96 "IP HOSP STAZ - OTH PUBLIC AMT-FAC 96";
label variable IPFOSR96 "IP HOSP STAZ-OT UNCLASS SRCE AMT-FAC 96";
label variable IPDEXP96 "TOTL HOSP STAZ DR EXP 96";
label variable IPDTCH96 "IP HOSP STAY CHARGES - DR 96";
label variable IPDSLF96 "IP HOSP STAZ-SELF/FAMILY AMT-DR 96";
label variable IPDMCR96 "IP HOSP STAZ-MEDICARE AMT- DR 96";
label variable IPDMCD96 "IP HOSP STAZ-MEDICAID AMT-DR 96";
label variable IPDPRV96 "IP HOSP STAZ-PRIV INS AMT- DR 96";
label variable IPDVA96 "IP HOSP STAZ-VA AMT-DR 96";
label variable IPDCHM96 "IP HOSP STAZ-CHAMPUS/CHAMPVA AMT-DR 96";
label variable IPDOFD96 "IP HOSP STAZ-OTHER FED AMT-DR 96";
label variable IPDSTL96 "IP HOSP STAZ-OTH ST/LOCAL AMT-DR 96";
label variable IPDWCP96 "IP HOSP STAZ-WORKERS COMP AMT-DR 96";
label variable IPDOPR96 "IP HOSP STAZ - OTH PRIVATE AMT-DR 96";
label variable IPDOPU96 "IP HOSP STAZ - OTH PUBLIC AMT-DR 96";
label variable IPDOSR96 "IP HOSP STAZ-OT UNCLASS SORCE AMT-DR 96";
label variable IPNGTD96 "# NIGHTS IN HOSP FOR DISCHARGES, 1996";
label variable DVTOT96 "# DENTAL CARE VISITS 96";
label variable DVTTCH96 "TOTAL DENTAL CARE VISIT CHARGES 96";
label variable DVTEXP96 "TOTAL DENTAL CARE EXP 96";
label variable DVTSLF96 "ALL DENTAL CARE -SELF/FAMILY AMT 96";
label variable DVTMCR96 "ALL DENTAL CARE -MEDICARE AMT 96";
label variable DVTMCD96 "ALL DENTAL CARE -MEDICAID AMT 96";
label variable DVTPRV96 "ALL DENTAL CARE -PRIVATE INS AMT 96";
label variable DVTVA96 "ALL DENTAL CARE-VA AMT 96";
label variable DVTCHM96 "ALL DENTAL CARE-CHAMPUS/CHAMPVA AMT 96";
label variable DVTOFD96 "ALL DENTAL CARE -OTHER FEDRL AMT 96";
label variable DVTSTL96 "ALL DENTAL CARE-OTH ST/LOCAL AMT 96";
label variable DVTWCP96 "ALL DENTAL CARE-WORKERS COMP AMT 96";
label variable DVTOPR96 "ALL DENTAL CARE - OTH PRIVATE AMT 96";
label variable DVTOPU96 "ALL DENTAL CARE - OTH PUBLIC AMT 96";
label variable DVTOSR96 "ALL DENT CARE-OT UNCLASS SRCE AMT 96";
label variable DVGEN96 "# GENERAL DENTIST VISITS 96";
label variable DVGTCH96 "GENERAL DENTAL CARE VISIT CHARGES 96";
label variable DVGEXP96 "TOTAL GENERAL DENTIST EXP 96";
label variable DVGSLF96 "GNRL DENTAL VISITS -SELF/FAM AMT 96";
label variable DVGMCR96 "GNRL DENTAL VISITS -MEDICARE AMT 96";
label variable DVGMCD96 "GNRL DENTAL VISITS -MEDICAID AMT 96";
label variable DVGPRV96 "GNRL DENTAL VISITS -PRIVATE INS AMT 96";
label variable DVGVA96 "GNRL DENTAL VISITS -VA AMT 96";
label variable DVGCHM96 "GNRL DENTAL VISITS-CHMPUS/CHMPVA AMT 96";
label variable DVGOFD96 "GNRL DENTAL VISITS- OTHER FED AMT 96";
label variable DVGSTL96 "GNRL DENTAL VISITS - OTH ST/LOCAL AMT 96";
label variable DVGWCP96 "GNRL DENTAL VISITS - WORKERS COMP AMT 96";
label variable DVGOPR96 "GNRL DENTAL VISITS - OTH PRIVATE AMT 96";
label variable DVGOPU96 "GNRL DENTAL VISITS - OTH PUBLIC AMT 96";
label variable DVGOSR96 "GNRL DENT VSTS - OT UNCLASS SRCE AMT 96";
label variable DVORTH96 "# ORTHODONTIST VISITS 96";
label variable DVOTCH96 "ORTHODONTIST VISIT CHARGES 96";
label variable DVOEXP96 "TOTAL ORTHODONTIST EXP 96";
label variable DVOSLF96 "ORTHODONTIST VISITS -SELF/FAMILY AMT 96";
label variable DVOMCR96 "ORTHODONTIST VISITS -MEDICARE AMT 96";
label variable DVOMCD96 "ORTHODONTIST VISITS -MEDICAID AMT 96";
label variable DVOPRV96 "ORTHODONTIST VISITS -PRIVATE INS AMT 96";
label variable DVOVA96 "ORTHODONTIST VISITS-VA AMT 96";
label variable DVOCHM96 "ORTHODONTIST VISITS-CHMPUS/CHMPVA AMT 96";
label variable DVOOFD96 "ORTHODONTIST VISITS-OTHR FED AMT 96";
label variable DVOSTL96 "ORTHODONTIST VISITS-OTHR ST/LOCAL AMT 96";
label variable DVOWCP96 "ORTHODONTIST VISITS-WORKERS COMP AMT 96";
label variable DVOOPR96 "ORTHODONTIST VISITS-OTHR PRIVATE AMT 96";
label variable DVOOPU96 "ORTHODONTIST VISITS-OTHR PUBLIC AMT 96";
label variable DVOOSR96 "ORTHODONT VSTS - OT UNCLASS SRCE AMT 96";
label variable HHTOTM96 "# MOS W/ AT LEAST 1 HOME HLTH VST, 1996";
label variable HHTOTD96 "# HOME HEALTH PROVIDER DAYS, 1996";
label variable HHAGM96 "# MONTHS W/ AGENCY HOME HEALTH CARE 96";
label variable HHAGD96 "# AGENCY HOME HEALTH PROVIDER DAYS 96";
label variable HHATCH96 "HOME HEALTH AGENCY VISIT CHARGES 96";
label variable HHAEXP96 "TOTAL HOME HEALTH AGENCY EXP 96";
label variable HHASLF96 "HOME HLTH AGENCY -SELF/FAMILY AMT 96";
label variable HHAMCR96 "HOME HLTH AGENCY -MEDICARE AMT 96";
label variable HHAMCD96 "HOME HLTH AGENCY -MEDICAID AMT 96";
label variable HHAPRV96 "HOME HLTH AGENCY -PRIVATE INS AMT 96";
label variable HHAVA96 "HOME HLTH AGENCY-VA AMT 96";
label variable HHACHM96 "HOME HLTH AGENCY-CHAMPUS/CHAMPVA AMT 96";
label variable HHAOFD96 "HOME HLTH AGENCY-OTHER FED AMT 96";
label variable HHASTL96 "HOME HLTH AGENCY-OTHR ST/LOCAL AMT 96";
label variable HHAWCP96 "HOME HLTH AGENCY- WORKERS COMP AMT 96";
label variable HHAOPR96 "HOME HLTH AGENCY - OTH PRIVATE AMT 96";
label variable HHAOPU96 "HOME HLTH AGENCY - OTH PUBLIC AMT 96";
label variable HHAOSR96 "H HLTH AGENCY - OT UNCLASS SRCE AMT 96";
label variable HHINDM96 "# MNTHS W/NON-AGENCY HOME HLTH CARE 96";
label variable HHINDD96 "# NON-AGENCY HOME HEALTH PROVIDR DAYS 96";
label variable HHNTCH96 "HOME HEALTH NON-AGENCY VISIT CHARGES 96";
label variable HHNEXP96 "TOTAL HOME HEALTH NON-AGNCY EXP 96";
label variable HHNSLF96 "HOME HLTH NON-AGNCY -SELF/FAM AMT 96";
label variable HHNMCR96 "HOME HLTH NON-AGNCY -MEDICARE AMT 96";
label variable HHNMCD96 "HOME HLTH NON-AGNCY -MEDICAID AMT 96";
label variable HHNPRV96 "HOME HLTH NON-AGNCY -PRIV INS AMT 96";
label variable HHNVA96 "HOME HLTH NON-AGNCY-VA AMT 96";
label variable HHNCHM96 "HOME HLTH NON-AGNCY-CHMPUS/CHMPVA AMT 96";
label variable HHNOFD96 "HOME HLTH NON-AGNCY-OTHR FED AMT 96";
label variable HHNSTL96 "HOME HLTH NON-AGNCY-OTHR ST/LOCL AMT 96";
label variable HHNWCP96 "HOME HLTH NON-AGNCY-WORKERS COMP AMT 96";
label variable HHNOPR96 "HOME HLTH NON-AGNCY-OTH PRIVATE AMT 96";
label variable HHNOPU96 "HOME HLTH NON-AGNCY-OTH PUBLIC AMT 96";
label variable HHNOSR96 "H HLTH NON-AGNCY-OT UNCLASS SRCE AMT 96";
label variable HHINFM96 "# MONTHS W/ INFORMAL HOME HLTH CARE 96";
label variable HHINFD96 "# INFORMAL HOME HEALTH PROVIDER DAYS 96";
label variable VISEXP96 "TOTAL GLASSES/CONTACT LENS EXP 96";
label variable VISTCH96 "GLASSES/CONTACT LENSES CHARGES 96";
label variable VISSLF96 "GLASSES/CNTCT LENSES -SELF/FAM AMT 96";
label variable VISMCR96 "GLASSES/CNTCT LENSES-MEDICARE AMT 96";
label variable VISMCD96 "GLASSES/CNTCT LENSES-MEDICAID AMT 96";
label variable VISPRV96 "GLASSES/CNTCT LENSES-PRIV INS AMT 96";
label variable VISVA96 "GLASSES/CNTCT LENSES-VA AMT 96";
label variable VISCHM96 "GLASSES/LENSES-CHAMPUS/CHAMPVA AMT 96";
label variable VISOFD96 "GLASSES/CNTCT LENSES-OTHR FED AMT 96";
label variable VISSTL96 "GLASSES/CNTCT LENSES-OTH ST/LOCL AMT 96";
label variable VISWCP96 "GLASSES/CNTCT LENSES-WORKERS COMP AMT 96";
label variable VISOPR96 "GLASSES/CNTCT LENSES-OTH PRIVATE AMT 96";
label variable VISOPU96 "GLASSES/CNTCT LENSES-OTH PUBLIC AMT 96";
label variable VISOSR96 "GLASES/CNTCT LENSE-OT UNCLAS SRCE AMT 96";
label variable OTHTCH96 "OTHER EQUP/SUPPLIES CHARGES 96";
label variable OTHEXP96 "TOT OTHER EQUIP/SPLY (EXCL DIAB) EXP 96";
label variable OTHSLF96 "OTHER EQUP/SUPPLIES -SELF/FAM AMT 96";
label variable OTHMCR96 "OTHER EQUP/SUPPLIES-MEDICARE AMT 96";
label variable OTHMCD96 "OTHER EQUP/SUPPLIES-MEDICAID AMT 96";
label variable OTHPRV96 "OTHER EQUP/SUPPLIES-PRIV INS AMT 96";
label variable OTHVA96 "OTHER EQUP/SUPPLY-VA AMT 96";
label variable OTHCHM96 "OTHER EQUP/SUPPLY-CHAMPUS/CHAMPVA AMT 96";
label variable OTHOFD96 "OTHER EQUP/SUPPLIES-OTHR FEDRL AMT 96";
label variable OTHSTL96 "OTHER EQUP/SUPPLY-OTHR ST/LOCAL AMT 96";
label variable OTHWCP96 "OTHER EQUP/SUPPLY -WORKERS COMP AMT 96";
label variable OTHOPR96 "OTHER EQUP/SUPPLY-OTH PRIVATE AMT 96";
label variable OTHOPU96 "OTHER EQUP/SUPPLY -OTH PUBLIC AMT 96";
label variable OTHOSR96 "OTH EQUP/SUPLY -OT UNCLASS SRCE AMT 96";
label variable RXTOT96 "# PRESC MEDS INCL REFILLS 96";
label variable RXEXP96 "TOTAL RX-EXP 96";
label variable RXSLF96 "TOTAL RX-SELF/FAMILY AMT 96";
label variable RXMCR96 "TOTAL RX--MEDICARE AMT 96";
label variable RXMCD96 "TOTAL RX-MEDICAID AMT 96";
label variable RXPRV96 "TOTAL RX-PRIVATE INS AMT 96";
label variable RXVA96 "TOTAL RX-VA AMT 96";
label variable RXCHM96 "TOTAL RX-CHAMPUS/CHAMPVA AMT 96";
label variable RXOFD96 "TOTAL RX-OTHER FED AMT 96";
label variable RXSTL96 "TOTAL RX-OTHER ST/LOCAL AMT 96";
label variable RXWCP96 "TOTAL RX-WORKERS COMP AMT 96";
label variable RXOPR96 "TOTAL RX - OTH PRIVATE AMT 96";
label variable RXOPU96 "TOTAL RX - OTH PUBLIC AMT 96";
label variable RXOSR96 "TOT RX-OTH UNCLASS SRCE AMT 96";
label variable WGTRU2T "FAMILY LEVEL ROUND 2 WEIGHT";
label variable WGTSP2T "PERSON ROUND 2 WEIGHT";
label variable VARSTRT2 "VARIANCE ESTIMATION STRATUM - ROUND2";
label variable VARPSU2 "VARIANCE ESTIMATION PSU - ROUND 2";
label variable WTFAMF96 "POVERTY ADJUSTED FAMILY WEIGHT";
label variable WTCFAM96 "POV ADJ FAMILY WGT-CPS FAM ON 12/31/96";
label variable WTDPER96 "POVERTY/MORTALITY ADJUSTED PERS LEVL WGT";
label variable VARSTR96 "VARIANCE ESTIMATION STRATUM - 1996";
label variable VARPSU96 "VARIANCE ESTIMATION PSU - 1996";


*DEFINE VALUE LABELS FOR REPORTS;
label define H120001X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120002X
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FULL-TIME ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H120003X
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FULL-TIME ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H120004X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120005X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120006X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120007X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120008X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120009X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H120010X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H120011X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120012X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120013X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120014X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 $1 - $100"
         2 "2 $101 - $500"
         3 "3 $501 - $1500"
         4 "4 $1501 - $3000"
         6 "6 $5001 OR MORE" ;

label define H120015X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120016X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 1 TIME"
         2 "2 2-4 TIMES"
         3 "3 5-10 TIMES"
         4 "4 11-20 TIMES"
         5 "5 21-30 TIMES"
         6 "6 31 OR MORE TIMES" ;

label define H120017X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND" ;

label define H120018X
         1 "1 ORIGINAL RESPONSE"
         3 "3 MISSING VALUE SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H120019X
         -3 "-3 NO DATA IN ROUND"
         0 "0" ;

label define H120020X
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120021X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120022X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120023X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120024X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H120025X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HAVE APPOINTMENT"
         2 "2 JUST WALKS IN"
         3 "3 SOMETIMES APPOINTM,SOMETIMES WALKS IN" ;

label define H120026X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120027X
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED" ;

label define H120028X
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H120029X
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY" ;

label define H120030X
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H120031X
         -3 "-3 NO DATA IN ROUND"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H120032X
         -3 "-3 NO DATA IN ROUND"
         1996 "1996" ;

label define H120033X
         -3 "-3 NO DATA IN ROUND"
         1996 "1996" ;

label define H120034X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICUTLY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H120035X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H120036X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H120037X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         95 "95 HOURS VARY" ;

label define H120038X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120039X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1"
         2 "2" ;

label define H120040X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H120041X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         1 "1 YES"
         2 "2 NO" ;

label define H120042X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H120043X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H120044X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H120045X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H120046X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120047X
         1 "1 ORIGINAL RESPONSE"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H120048X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120049X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         1 "1 LIMITED IN ATTENDANCE"
         2 "2 UNABLE TO ATTEND"
         3 "3 NEITHER" ;

label define H120050X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120051X
         1 "1 ORIGINAL RESPONSE"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H120052X
         -3 "-3 NO DATA IN ROUND"
         0 "0" ;

label define H120053X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120054X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120055X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120056X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120057X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120058X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120059X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120060X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120061X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120062X
         1 "1 ORIGINAL RESPONSE"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H120063X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120064X
         -3 "-3 NO DATA IN ROUND"
         0 "0" ;

label define H120065X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120066X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120067X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120068X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H120069X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS A CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H120070X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120071X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120072X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120073X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120074X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120075X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120076X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H120077X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120078X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120079X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AGRICULTURE, FORESTRY, FISHERIES"
         10 "10 ENTERTAINMENT & RECREATION"
         11 "11 PROFESSIONAL SERVICES"
         12 "12 PUBLIC ADMINISTRATION"
         13 "13 INDUSTRY UNKNOWN"
         14 "14 ACTIVE MILITARY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 TRANSPORTATION, COMMUNICATION, UTILITIES"
         6 "6 SALES"
         7 "7 FINANCE, INSURANCE, REAL ESTATE"
         8 "8 REPAIR SERVICES"
         9 "9 PERSONAL SERVICES" ;

label define H120080X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AGRICULTURE, FORESTRY, FISHERIES"
         10 "10 ENTERTAINMENT & RECREATION"
         11 "11 PROFESSIONAL SERVICES"
         12 "12 PUBLIC ADMINISTRATION"
         13 "13 INDUSTRY UNKNOWN"
         14 "14 ACTIVE MILITARY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 TRANSPORTATION, COMMUNICATION, UTILITIES"
         6 "6 SALES"
         7 "7 FINANCE, INSURANCE, REAL ESTATE"
         8 "8 REPAIR SERVICES"
         9 "9 PERSONAL SERVICES" ;

label define H120081X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AGRICULTURE, FORESTRY, FISHERIES"
         10 "10 ENTERTAINMENT & RECREATION"
         11 "11 PROFESSIONAL SERVICES"
         12 "12 PUBLIC ADMINISTRATION"
         13 "13 INDUSTRY UNKNOWN"
         14 "14 ACTIVE MILITARY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 TRANSPORTATION, COMMUNICATION, UTILITIES"
         6 "6 SALES"
         7 "7 FINANCE, INSURANCE, REAL ESTATE"
         8 "8 REPAIR SERVICES"
         9 "9 PERSONAL SERVICES" ;

label define H120082X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120083X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120084X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO"
         3 "3 RESPONDENT INDICATES DOES NOT APPLY" ;

label define H120085X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DON'T KNOW"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PROFESSIONAL, TECHNICAL AND KINDRED"
         10 "10 FARM OWNERS AND MANAGERS"
         11 "11 FARM LABORERS AND FOREMEN"
         12 "12 UNKNOWN"
         13 "13 ACTIVE MILITARY"
         14 "14 LAST WORKED PRIOR TO 1984"
         2 "2 MANAGERIAL AND ADMINISTRATIVE"
         3 "3 SALES WORKERS"
         4 "4 CLERICAL AND KINDRED WORKERS"
         5 "5 CRAFTSMEN AND FOREMEN"
         6 "6 OPERATIVES"
         7 "7 TRANSPORT OPERATIVES"
         8 "8 SERVICE WORKERS"
         9 "9 LABORERS, NOT FARMING" ;

label define H120086X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DON'T KNOW"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PROFESSIONAL, TECHNICAL AND KINDRED"
         10 "10 FARM OWNERS AND MANAGERS"
         11 "11 FARM LABORERS AND FOREMEN"
         12 "12 UNKNOWN"
         13 "13 ACTIVE MILITARY"
         14 "14 LAST WORKED PRIOR TO 1984"
         2 "2 MANAGERIAL AND ADMINISTRATIVE"
         3 "3 SALES WORKERS"
         4 "4 CLERICAL AND KINDRED WORKERS"
         5 "5 CRAFTSMEN AND FOREMEN"
         6 "6 OPERATIVES"
         7 "7 TRANSPORT OPERATIVES"
         8 "8 SERVICE WORKERS"
         9 "9 LABORERS, NOT FARMING" ;

label define H120087X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DON'T KNOW"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PROFESSIONAL, TECHNICAL AND KINDRED"
         10 "10 FARM OWNERS AND MANAGERS"
         11 "11 FARM LABORERS AND FOREMEN"
         12 "12 UNKNOWN"
         13 "13 ACTIVE MILITARY"
         14 "14 LAST WORKED PRIOR TO 1984"
         2 "2 MANAGERIAL AND ADMINISTRATIVE"
         3 "3 SALES WORKERS"
         4 "4 CLERICAL AND KINDRED WORKERS"
         5 "5 CRAFTSMEN AND FOREMEN"
         6 "6 OPERATIVES"
         7 "7 TRANSPORT OPERATIVES"
         8 "8 SERVICE WORKERS"
         9 "9 LABORERS, NOT FARMING" ;

label define H120088X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H120089X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120090X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120091X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND" ;

label define H120092X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND" ;

label define H120093X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO PROBLEM"
         1 "1 LITTLE PROBLEM"
         2 "2 MEDIUM PROBLEM"
         3 "3 BIG PROBLEM"
         4 "4 VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H120094X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE" ;

label define H120095X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE" ;

label define H120096X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE" ;

label define H120097X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE"
         996 "996 NOT WORK" ;

label define H120098X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE"
         996 "996 NOT WORK" ;

label define H120099X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE"
         996 "996 NOT WORK" ;

label define H120100X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE"
         996 "996 NOT ATT SCHL" ;

label define H120101X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE"
         996 "996 NOT ATT SCHL" ;

label define H120102X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         995 "995 NONE"
         996 "996 NOT ATT SCHL" ;

label define H120103X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         1 "1 YES"
         2 "2 NO" ;

label define H120104X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 ITEMIZED"
         2 "2 STANDARD" ;

label define H120105X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 TWICE A YEAR OR MORE"
         2 "2 ONCE A YEAR"
         3 "3 LESS THAN ONCE A YEAR"
         4 "4 NEVER" ;

label define H120106X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES" ;

label define H120107X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEPENDENTS IN RU"
         2 "2 DEPENDENTS IN AND OUT OF RU"
         3 "3 DEPENDENTS OUT OF RU" ;

label define H120108X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0" ;

label define H120109X
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H120110X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120111X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 HAVE NO REGULAR DOCTOR"
         4 "4 ALTERNATIVE CARE PRACTITIONER" ;

label define H120112X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120113X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE-CM JOB" ;

label define H120114X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE-CM JOB" ;

label define H120115X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE-CM JOB" ;

label define H120116X
         1 "1 ORIGINAL RESPONSE"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H120117X
         -3 "-3 NO DATA IN ROUND"
         0 "0" ;

label define H120118X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120119X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120120X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120121X
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H120122X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120123X
         0 "0 NUMBER OF VISITS"
         1 "1 NUMBER OF VISITS"
         2 "2 NUMBER OF VISITS" ;

label define H120124X
         0 "0"
         35 "35" ;

label define H120125X
         0 "0"
         166 "166" ;

label define H120126X
         0 "0"
         1989 "1989" ;

label define H120127X
         -1 "-1 INAPPLICABLE"
         0 "0"
         1 "1 - 1" ;

label define H120128X
         0 "0"
         178 "178"
         43 "43" ;

label define H120129X
         -1 "-1 INAPPLICABLE"
         0 "0"
         1 "1"
         2 "2"
         3 "3" ;

label define H120130X
         0 "0"
         35 "35" ;

label define H120131X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NEVER ATTENDED SCHOOL/KINDERGARTEN"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H120132X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NEVER ATTENDED SCHOOL/KINDERGARTEN"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H120133X
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NEVER ATTENDED SCHOOL/KINDERGARTEN"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H120134X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 RESPONDENT INDICATES DOES NOT APPLY" ;

label define H120135X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 RESPONDENT INDICATES DOES NOT APPLY" ;

label define H120136X
         1 "1 PERSON IS ELIGIBLE"
         3 "3 PERSON IS NOT ELIGIBLE" ;

label define H120137X
         1 "1 PERSON IS ELIGIBLE"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H120138X
         1 "1 PERSON IS ELIGIBLE"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H120139X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 1 INT DATE"
         3 "3 JOB DURING RD 1 REF PER"
         4 "4 NOT EMPLOYED DURING RD 1" ;

label define H120140X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 2 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 2 INT DATE"
         3 "3 JOB DURING RD 2 REF PER"
         4 "4 NOT EMPLOYED DURING RD 2" ;

label define H120141X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED ON 12/31/96"
         2 "2 JOB TO RETURN TO ON 12/31/96"
         3 "3 JOB 96 PART RD3, NOT ON 12/31/96"
         4 "4 NOT EMPLOYED DURING 1996 PART" ;

label define H120142X
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H120143X
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H120144X
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST" ;

label define H120145X
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H120146X
         -3 "-3 NO DATA IN ROUND"
         1996 "1996" ;

label define H120147X
         -3 "-3 NO DATA IN ROUND"
         1996 "1996" ;

label define H120148X
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H120149X
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H120150X
         -3 "-3 NO DATA IN ROUND"
         1996 "1996" ;

label define H120151X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H120152X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H120153X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         95 "95 HOURS VARY" ;

label define H120154X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120155X
         0 "0"
         127 "127"
         228 "228"
         50 "50" ;

label define H120156X
         0 "0"
         5 "5" ;

label define H120157X
         0 "0"
         12 "12 - 12"
         60 "60" ;

label define H120158X
         0 "0"
         7 "7" ;

label define H120159X
         0 "0"
         206 "206"
         240 "240" ;

label define H120160X
         0 "0"
         198 "198"
         32 "32" ;

label define H120161X
         -1 "-1 INAPPLICABLE"
         0 "0"
         1 "1" ;

label define H120162X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120163X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120164X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120165X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H120166X
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H120167X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND" ;

label define H120168X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND" ;

label define H120169X
         1 "1 ORIGINAL RESPONSE"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H120170X
         -1 "-1 INAPP, NOT MEM OF 12/31 FAMILY"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H120171X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120172X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIMARY"
         2 "2 SECONDARY" ;

label define H120173X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SINGLE"
         2 "2 MARRIED FILING JOINT RETURN"
         3 "3 MARRIED FILING SEPARATELY"
         4 "4 HEAD OF HOUSEHOLD W/QUALFYING PERS"
         5 "5 QUALIFYING WIDOW(ER) W/DEP CHILD" ;

label define H120174X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICUTLY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H120175X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H120176X
         -1 "-1 INAPPLICABLE"
         0 "0 NONRESPONDING 12/31 FAMILY"
         1 "1 RESPONDING 12/31 FAMILY" ;

label define H120177X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120178X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H120179X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120180X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0" ;

label define H120181X
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H120182X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H120183X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H120184X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY FALSE"
         2 "2 MOSTLY FALSE"
         3 "3 MOSTLY TRUE"
         4 "4 DEFINITELY TRUE" ;

label define H120185X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DRIVE/IS DRIVEN"
         2 "2 TAXI,BUS,TRAIN,OTHER PUBLIC TRANSPORT"
         3 "3 WALKS"
         91 "91 OTHER WAY" ;

label define H120186X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H120187X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120188X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY SATISFIED"
         2 "2 SOMEWHAT SATISFIED"
         3 "3 NOT TOO SATISFIED"
         4 "4 NOT AT ALL SATISFIED" ;

label define H120189X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY FALSE"
         2 "2 MOSTLY FALSE"
         3 "3 MOSTLY TRUE"
         4 "4 DEFINITELY TRUE" ;

label define H120190X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120191X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120192X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SLIGHT IMPAIRMENT"
         3 "3 MODERATE IMPAIRMENT"
         4 "4 MAJOR IMPAIRMENT"
         5 "5 DEAF" ;

label define H120193X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120194X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120195X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120196X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120197X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120198X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120199X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120200X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120201X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120202X
         0 "0"
         45 "45" ;

label define H120203X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120204X
         0 "0"
         1 "1" ;

label define H120205X
         0 "0"
         75 "75"
         873 "873" ;

label define H120206X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120207X
         0 "0"
         4 "4" ;

label define H120208X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120209X
         0 "0"
         1 "1" ;

label define H120210X
         0 "0"
         54 "54" ;

label define H120211X
         0 "0"
         756 "756" ;

label define H120212X
         0 "0"
         140 "140" ;

label define H120213X
         0 "0"
         1000 "1000"
         756 "756" ;

label define H120214X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120215X
         -1 "-1 INAPPLICABLE"
         0 "0"
         1 "1" ;

label define H120216X
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16 - INAPPLICABLE" ;

label define H120217X
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16 - INAPPLICABLE" ;

label define H120218X
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16 - INAPPLICABLE" ;

label define H120219X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H120220X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK" ;

label define H120221X
         1 "1 HISPANIC"
         2 "2 NOT HISPANIC" ;

label define H120222X
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PUERTO RICAN"
         2 "2 CUBAN"
         3 "3 MEXICAN/MEXICAN AMERI/MEXICANO/CHICANO"
         4 "4 OTHER LATIN AMERICAN/OTHER SPANISH"
         5 "5 NON-HISPANIC" ;

label define H120223X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H120224X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120225X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120226X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H120227X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H120228X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H120229X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120230X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120231X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120232X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120233X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120234X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120235X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120236X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120237X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120238X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120239X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120240X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120241X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120242X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120243X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120244X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120245X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120246X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120247X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120248X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120249X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120250X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120251X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120252X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120253X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120254X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120255X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120256X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120257X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120258X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120259X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120260X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120261X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120262X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120263X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120264X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120265X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120266X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120267X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120268X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120269X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120270X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120271X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120272X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120273X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120274X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120275X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120276X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120277X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120278X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120279X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120280X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120281X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120282X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120283X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120284X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120285X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120286X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120287X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120288X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120289X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120290X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120291X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120292X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120293X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120294X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120295X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120296X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120297X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120298X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120299X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120300X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120301X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120302X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120303X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120304X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120305X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120306X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120307X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120308X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H120309X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H120310X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION:HRLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PEICEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS" ;

label define H120311X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H120312X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H120313X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H120314X
         0 "0 NO"
         1 "1 YES" ;

label define H120315X
         0 "0 NO"
         1 "1 YES" ;

label define H120316X
         0 "0 NO"
         1 "1 YES" ;

label define H120317X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120318X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120319X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120320X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120321X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120322X
         0 "0 NON-RESPONSE"
         1 "1 YES"
         2 "2 NO" ;

label define H120323X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         95 "95 DOES NOT HAVE HEALTH INSURANCE" ;

label define H120324X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120325X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120326X
         0 "0 NOT INSCOPE-NOT RESP/NOT IN AN RU"
         1 "1 INSCOPE ON 12/31/96"
         2 "2 NON INSCOPE ON 12/31/96" ;

label define H120327X
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H120328X
         1 "1 INSCOPE AT SOME TIME DURING 1996"
         2 "2 OUT-OF-SCOPE FOR ALL OF 1996" ;

label define H120329X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/96"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         7 "7 NOT IN RU, JOINED IN LATER ROUND" ;

label define H120330X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/96"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H120331X
         1 "1 ANY PRIVATE"
         2 "2 PUBLIC ONLY"
         3 "3 UNINSURED" ;

label define H120332X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120333X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120334X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120335X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120336X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120337X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120338X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120339X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120340X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120341X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120342X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120343X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120344X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120345X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120346X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120347X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120348X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120349X
         1 "1 ORIGINAL RESPONSE"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H120350X
         -3 "-3 NO DATA IN ROUND"
         0 "0" ;

label define H120351X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0" ;

label define H120352X
         0 "0"
         1435 "1435"
         229 "229"
         480 "480" ;

label define H120353X
         0 "0 NUMBER OF DISCHARGES"
         1 "1 NUMBER OF DISCHARGES"
         2 "2 NUMBER OF DISCHARGES" ;

label define H120354X
         0 "0"
         152 "152"
         35 "35"
         5 "5"
         75 "75" ;

label define H120355X
         0 "0"
         103 "103"
         3919 "3919" ;

label define H120356X
         0 "0"
         112 "112"
         4580 "4580"
         72 "72"
         904 "904" ;

label define H120357X
         0 "0"
         2 "2" ;

label define H120358X
         0 "0"
         1873 "1873" ;

label define H120359X
         0 "0"
         112 "112"
         1303 "1303"
         223 "223"
         4160 "4160" ;

label define H120360X
         -9 "-9 NOT ASCERTAINED"
         0 "0 NUMBER OF NIGHTS"
         3 "3 NUMBER OF NIGHTS" ;

label define H120361X
         0 "0 NUMBER OF STAYS"
         1 "1 NUMBER OF STAYS" ;

label define H120362X
         1 "1 ORIGINAL RESPONSE"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H120363X
         -3 "-3 NO DATA IN ROUND"
         0 "0" ;

label define H120364X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         0 "0" ;

label define H120365X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H120366X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120367X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H120368X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H120369X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H120370X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H120371X
         -3 "-3 NO DATA IN ROUND"
         1 "1 KEY"
         2 "2 NOT KEY" ;

label define H120372X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H120373X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120374X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H120375X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICUTLY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H120376X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120377X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120378X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120379X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120380X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120381X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120382X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 OFFICE"
         2 "2 HOSP, NOT ER"
         3 "3 HOSP, ER" ;

label define H120383X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120384X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DIFFERENT LANGUAGE"
         14 "14 COULD NOT GET TIME OFF WORK"
         15 "15 DK WHERE TO GO TO GET CARE"
         16 "16 WAS REFUSED SERVICES"
         18 "18 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 PRE-EXISTING CONDITION"
         4 "4 INS CO REQUIRED REFERRL-COULD NOT GET"
         5 "5 DOCTOR REFUSED FAMILY INS PLAN"
         6 "6 MEDICAL CARE TOO FAR AWAY"
         7 "7 CAN NOT DRIVE/NO CAR/NO PUBLIC TRANSP"
         8 "8 TOO EXPENSIVE TO GET THERE"
         91 "91 OTHER" ;

label define H120385X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H120386X
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND 1"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND 1"
         8 "8 WIDOWED IN ROUND 1"
         9 "9 DIVORCED IN ROUND 1" ;

label define H120387X
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND 2"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND 2"
         8 "8 WIDOWED IN ROUND 2"
         9 "9 DIVORCED IN ROUND 2" ;

label define H120388X
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         1 "1 MARRIED"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE" ;

label define H120389X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120390X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120391X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120392X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120393X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120394X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120395X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120396X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120397X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120398X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120399X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120400X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120401X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120402X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120403X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120404X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120405X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120406X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120407X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120408X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120409X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120410X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120411X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120412X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120413X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120414X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120415X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120416X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120417X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120418X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120419X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120420X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120421X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120422X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120423X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120424X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120425X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120426X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120427X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120428X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120429X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120430X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120431X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120432X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120433X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120434X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120435X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120436X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120437X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120438X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120439X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120440X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120441X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120442X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120443X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120444X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120445X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120446X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0" ;

label define H120447X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120448X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120449X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICUTLY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H120450X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120451X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120452X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H120453X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H120454X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H120455X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H120456X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         999 "999" ;

label define H120457X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         999 "999" ;

label define H120458X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO PROBLEM"
         1 "1 LITTLE PROBLEM"
         2 "2 MEDIUM PROBLEM"
         3 "3 BIG PROBLEM"
         4 "4 VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H120459X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120460X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120461X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120462X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H120463X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H120464X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H120465X
         -3 "-3 NO DATA IN ROUND"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H120466X
         -3 "-3 NO DATA IN ROUND"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H120467X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120468X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H120469X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0" ;

label define H120470X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120471X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120472X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120473X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120474X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120475X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120476X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120477X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120478X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120479X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120480X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY FALSE"
         2 "2 MOSTLY FALSE"
         3 "3 MOSTLY TRUE"
         4 "4 DEFINITELY TRUE" ;

label define H120481X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ONCE"
         2 "2 SEVERAL TIMES" ;

label define H120482X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H120483X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H120484X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H120485X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ONCE"
         2 "2 SEVERAL TIMES" ;

label define H120486X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120487X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120488X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H120489X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H120490X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H120491X
         0 "0"
         19 "19"
         2 "2" ;

label define H120492X
         0 "0"
         11 "11"
         113 "113"
         205 "205"
         51 "51" ;

label define H120493X
         -1 "-1 INAPPLICABLE"
         0 "0"
         1 "1"
         2 "2" ;

label define H120494X
         0 "0"
         29 "29"
         30 "30"
         84 "84" ;

label define H120495X
         0 "0"
         44 "44"
         56 "56" ;

label define H120496X
         -1 "-1 INAPPLICABLE"
         0 "0" ;

label define H120497X
         0 "0"
         248 "248"
         28 "28"
         6 "6" ;

label define H120498X
         0 "0"
         1 "1" ;

label define H120499X
         0 "0"
         15 "15" ;

label define H120500X
         0 "0"
         197 "197"
         29 "29" ;

label define H120501X
         0 "0"
         50 "50"
         76 "76" ;

label define H120502X
         -1 "-1 INAPPLICABLE"
         0 "0"
         1 "1"
         2 "2" ;

label define H120503X
         -1 "-1 INAPPLICABLE"
         0 "0"
         1 "1" ;

label define H120504X
         -1 "-1 INAPPLICABLE"
         0 "0"
         1 "1"
         2 "2" ;

label define H120505X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120506X
         0 "0"
         26 "26"
         375 "375"
         580 "580" ;

label define H120507X
         -1 "-1 INAPPLICABLE"
         0 "0" ;

label define H120508X
         -1 "-1 INAPPLICABLE"
         0 "0"
         1 "1" ;

label define H120509X
         0 "0"
         1054 "1054" ;

label define H120510X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         1 "1 YES"
         2 "2 NO" ;

label define H120511X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120512X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120513X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120514X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120515X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120516X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120517X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120518X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120519X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120520X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120521X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120522X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120523X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120524X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120525X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120526X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120527X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120528X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120529X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120530X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120531X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120532X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120533X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120534X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120535X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120536X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120537X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120538X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120539X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120540X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120541X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120542X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120543X
         0 "0"
         70 "70" ;

label define H120544X
         0 "0"
         214 "214" ;

label define H120545X
         0 "0"
         1 "1" ;

label define H120546X
         0 "0"
         4 "4"
         525 "525" ;

label define H120547X
         0 "0"
         1 "1" ;

label define H120548X
         0 "0"
         22 "22"
         70 "70" ;

label define H120549X
         0 "0"
         13 "13" ;

label define H120550X
         0 "0"
         214 "214" ;

label define H120551X
         0 "0"
         4 "4" ;

label define H120552X
         0 "0"
         168 "168"
         3 "3"
         310 "310"
         70 "70" ;

label define H120553X
         0 "0"
         1105 "1105"
         15 "15"
         613 "613"
         8 "8" ;

label define H120554X
         0 "0"
         525 "525" ;

label define H120555X
         -1 "-1 INAPPLICABLE"
         0 "0"
         1 "1" ;

label define H120556X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120557X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120558X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120559X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120560X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120561X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120562X
         0 "0"
         57 "57"
         62 "62"
         656 "656" ;

label define H120563X
         0 "0"
         38 "38" ;

label define H120564X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO/NOT WORK"
         996 "996 NOT WORK" ;

label define H120565X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO/NOT WORK"
         996 "996 NOT WORK" ;

label define H120566X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1 YES"
         2 "2 NO/NOT WORK"
         996 "996 NOT WORK" ;

label define H120567X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120568X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120569X
         1 "1 ORIGINAL RESPONSE"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H120570X
         -3 "-3 NO DATA IN ROUND"
         0 "0" ;

label define H120571X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120572X
         0 "0"
         1300 "1300"
         138 "138" ;

label define H120573X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         1 "1 YES"
         2 "2 NO" ;

label define H120574X
         0 "0"
         225 "225"
         5 "5"
         75 "75" ;

label define H120575X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120576X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120577X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 $1 - $50"
         2 "2 $51 - $100"
         3 "3 $101 - $200"
         5 "5 $501 OR MORE" ;

label define H120578X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120579X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H120580X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120581X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120582X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120583X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120584X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120585X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120586X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120587X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120588X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120589X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120590X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120591X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120592X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120593X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120594X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120595X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120596X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120597X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120598X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120599X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120600X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120601X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120602X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120603X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120604X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120605X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120606X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120607X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120608X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120609X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120610X
         1 "1 ORIGINAL RESPONSE"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H120611X
         -3 "-3 NO DATA IN ROUND"
         0 "0" ;

label define H120612X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H120613X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120614X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H120615X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H120616X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H120617X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120618X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120619X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120620X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120621X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120622X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120623X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120624X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120625X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120626X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120627X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120628X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120629X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120630X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120631X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120632X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120633X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120634X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120635X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120636X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120637X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120638X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120639X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120640X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120641X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120642X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120643X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120644X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120645X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120646X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120647X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120648X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120649X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120650X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120651X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120652X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120653X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120654X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120655X
         1 "1 LT 100% POV LINE"
         2 "2 100-124% POV LINE"
         3 "3 125-199% POV LINE"
         4 "4 200-399% POV LINE"
         5 "5 GE 400% POV LINE" ;

label define H120656X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120657X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1"
         2 "2" ;

label define H120658X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120659X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120660X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120661X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120662X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120663X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120664X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120665X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120666X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120667X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120668X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120669X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120670X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120671X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120672X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120673X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120674X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120675X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120676X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120677X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120678X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120679X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120680X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120681X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120682X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120683X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120684X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120685X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEARNING DISABILITY"
         2 "2 SENSORY IMPAIRED PROGRAM"
         3 "3 MENTALLY/PHYSICL IMPAIRED"
         4 "4 SMALL CLASS, INDIV HELP"
         5 "5 READING AND MATH HELP"
         6 "6 SPEECH CLASS"
         7 "7 OTHER" ;

label define H120686X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 5 YEARS"
         4 "4 MORE THAN 5 YEARS"
         5 "5 NEVER" ;

label define H120687X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY SATISFIED"
         2 "2 SOMEWHAT SATISFIED"
         3 "3 NOT TOO SATISFIED"
         4 "4 NOT AT ALL SATISFIED" ;

label define H120688X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FACILITY"
         2 "2 PERSON"
         3 "3 PERSON IN FACILITY PROV" ;

label define H120689X
         -1 "-1 NON-RESPONSE"
         -3 "-3 NO DATA IN ROUND"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H120690X
         -3 "-3 NO DATA IN ROUND"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H120691X
         -3 "-3 NO DATA IN ROUND"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H120692X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120693X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120694X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120695X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120696X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120697X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120698X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120699X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120700X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120701X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120702X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120703X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120704X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120705X
         -1 "-1 INAPPLICABLE"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 MOVED, FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU, NOT FT MIL"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN BETWEEN NHIS AND END OF R1"
         62 "62 INSTITUT PRIOR TO REF PER-R1 ONLY"
         63 "63 LEFT U.S. PRIOR TO REF PER-R1 ONLY" ;

label define H120706X
         -1 "-1 INAPPLICABLE"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 MOVED, FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE-R2 & R3 ONLY"
         22 "22 LEAVE INSTITUTION-R2 & R3 ONLY"
         24 "24 DIES IN INST DURING RD-R2 & R3 ONLY"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU, NOT FT MIL"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         74 "74 MOVED AS FT MIL, NOT TO A, W/OUT KEY" ;

label define H120707X
         -1 "-1 INAPPLICABLE"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 MOVED, FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE-R2 & R3 ONLY"
         22 "22 LEAVE INSTITUTION-R2 & R3 ONLY"
         23 "23 LEAVES INSTITUTION & DIES-R2 & 3 ONLY"
         24 "24 DIES IN INST DURING RD-R2 & R3 ONLY"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU, NOT FT MIL"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO A, W/OUT KEY" ;

label define H120708X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         1 "1 YES"
         2 "2 NO" ;

label define H120709X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120710X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120711X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120712X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120713X
         1 "1 ORIGINAL RESPONSE"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H120714X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120715X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120716X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120717X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120718X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120719X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120720X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120721X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120722X
         -3 "-3 NO DATA IN ROUND"
         0 "0" ;

label define H120723X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120724X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120725X
         1 "1 PERSON IS HISPANIC"
         2 "2 PERSON IS BLACK/NOT HISPANIC"
         3 "3 OTHER" ;

label define H120726X
         1 "1 AMERICAN INDIAN"
         2 "2 ALEUT, ESKIMO"
         3 "3 ASIAN OR PACIFIC ISLANDER"
         4 "4 BLACK"
         5 "5 WHITE"
         91 "91 OTHER" ;

label define H120727X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H120728X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120729X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICUTLY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H120730X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120731X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H120732X
         1 "1 ORIGINAL RESPONSE"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H120733X
         -3 "-3 NO DATA IN ROUND"
         0 "0" ;

label define H120734X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120735X
         -3 "-3 NO DATA IN ROUND"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         4 "4 BROTHER/STEP/HALF"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY" ;

label define H120736X
         -3 "-3 NO DATA IN ROUND"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         4 "4 BROTHER/STEP/HALF"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY" ;

label define H120737X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         95 "95 CARE PROVIDED BY REGULAR PROVIDER" ;

label define H120738X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120739X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120740X
         -3 "-3 NO DATA IN ROUND"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H120741X
         -3 "-3 NO DATA IN ROUND"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H120742X
         -3 "-3 NO DATA IN ROUND"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H120743X
         -3 "-3 NO DATA IN ROUND"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H120744X
         -3 "-3 NO DATA IN ROUND"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT" ;

label define H120745X
         -3 "-3 NO DATA IN ROUND"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT" ;

label define H120746X
         -3 "-3 NO DATA IN ROUND"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT" ;

label define H120747X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120748X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120749X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120750X
         -3 "-3 NO DATA IN ROUND"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         4 "4 BROTHER/STEP/HALF"
         42 "42 GREAT NEPHEW"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY" ;

label define H120751X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H120752X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H120753X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H120754X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H120755X
         -3 "-3 NO DATA IN ROUND"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H120756X
         -3 "-3 NO DATA IN ROUND"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H120757X
         -3 "-3 NO DATA IN ROUND"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H120758X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120759X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120760X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120761X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120762X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120763X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120764X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120765X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120766X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120767X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120768X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120769X
         -1 "-1 INAPPLICABLE"
         0 "0" ;

label define H120770X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120771X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120772X
         1 "1 ORIGINAL RESPONSE"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H120773X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H120774X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120775X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H120776X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120777X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120778X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120779X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120780X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120781X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120782X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120783X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120784X
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H120785X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120786X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120787X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120788X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H120789X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120790X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120791X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120792X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120793X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         1 "1 YES"
         2 "2 NO" ;

label define H120794X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         1 "1 YES, ENROLLED IN SPECIAL EDUCATION"
         2 "2 YES, RELATED SERVICES"
         3 "3 YES, BOTH"
         4 "4 NO"
         91 "91 OTHER" ;

label define H120795X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         1 "1 ACTIVE SPORTS"
         2 "2 GEN PHYSICAL ACTIVITY"
         3 "3 INTERACTION/COMMUNICATN"
         4 "4 ALL ACTIVITIES"
         5 "5 OTHER" ;

label define H120796X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, SPECIAL PROGRAM"
         2 "2 YES, EARLY INTERVENTION SERVICES"
         3 "3 YES, BOTH"
         4 "4 NO"
         91 "91 OTHER" ;

label define H120797X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120798X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120799X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H120800X
         -3 "-3 NO DATA IN ROUND"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H120801X
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H120802X
         -3 "-3 NO DATA IN ROUND"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H120803X
         -3 "-3 NO DATA IN ROUND"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H120804X
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H120805X
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H120806X
         1 "1 ORIGINAL RESPONSE"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H120807X
         -3 "-3 NO DATA IN ROUND"
         0 "0" ;

label define H120808X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120809X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         1 "1 DISABILITY"
         2 "2 SOME OTHER REASON" ;

label define H120810X
         1 "1 ORIGINAL RESPONSE"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H120811X
         -3 "-3 NO DATA IN ROUND"
         0 "0" ;

label define H120812X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120813X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120814X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120815X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120816X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120817X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120818X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120819X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120820X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120821X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120822X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120823X
         -3 "-3 NO DATA IN MONTH"
         1 "1 YES"
         2 "2 NO" ;

label define H120824X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120825X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICUTLY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO"
         5 "5 COMPLETLY UNABLE TO WALK" ;

label define H120826X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H120827X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H120828X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H120829X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H120830X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H120831X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H120832X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H120833X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H120834X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H120835X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICUTLY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H120836X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LONG FORM 1040"
         2 "2 SHORT FORM 1040A"
         3 "3 SHORT FORM 1040EZ"
         91 "91 OTHER" ;

label define H120837X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120838X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         0 "0" ;

label define H120839X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120840X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120841X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120842X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120843X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120844X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120845X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120846X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120847X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120848X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120849X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120850X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120851X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120852X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120853X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO PROBLEM"
         1 "1 LITTLE PROBLEM"
         2 "2 MEDIUM PROBLEM"
         3 "3 BIG PROBLEM"
         4 "4 VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H120854X
         1 "1 ORIGINAL RESPONSE"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H120855X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         1 "1 YES"
         2 "2 NO" ;

label define H120856X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MD-GEN/FAM PRACTICE"
         10 "10 OTHER NON-MD PROVIDR"
         11 "11 UNKNOWN"
         2 "2 MD-INTERNAL MEDICINE"
         3 "3 MD-PEDIATRICS"
         4 "4 MD-OB/GYN"
         5 "5 MD-SURGERY"
         6 "6 MD-OTHER"
         7 "7 CHIROPRACTOR"
         8 "8 NURSE/NURSE PRACTNR"
         9 "9 PHYSICIAN'S ASST" ;

label define H120857X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOSP CLINIC/OUTPUT DEPT"
         2 "2 PRIV OFF IN HOSP"
         3 "3 HOSP ER"
         4 "4 NON-HOSP" ;

label define H120858X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H120859X
         1 "1 ORIGINAL RESPONSE"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H120860X
         -3 "-3 NO DATA IN ROUND"
         0 "0" ;

label define H120861X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         0 "0" ;

label define H120862X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO PROBLEM"
         1 "1 LITTLE PROBLEM"
         2 "2 MEDIUM PROBLEM"
         3 "3 BIG PROBLEM"
         4 "4 VERY BIG PROBLEM"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H120863X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120864X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120865X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120866X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120867X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120868X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120869X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120870X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120871X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120872X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY SATISFIED"
         2 "2 SOMEWHAT SATISFIED"
         3 "3 NOT TOO SATISFIED"
         4 "4 NOT AT ALL SATISFIED" ;

label define H120873X
         -3 "-3 NO DATA IN ROUND"
         0 "0" ;

label define H120874X
         -3 "-3 NO DATA IN ROUND"
         0 "0" ;

label define H120875X
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H120876X
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H120877X
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H120878X
         1 "1 ORIGINAL RESPONSE"
         3 "3 MISSING VALUE SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H120879X
         -3 "-3 NO DATA IN ROUND"
         0 "0" ;

label define H120880X
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H120881X
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H120882X
         0 "0"
         120 "120"
         43 "43"
         48 "48" ;

label define H120883X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 IMPAIRED NEAR, BUT NOT FAR"
         4 "4 IMPAIRED BOTH NEAR AND FAR"
         5 "5 BLIND" ;

label define H120884X
         0 "0"
         108 "108"
         164 "164"
         21 "21"
         212 "212"
         269 "269" ;

label define H120885X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         1 "1 YES"
         2 "2 NO" ;

label define H120886X
         1 "1 ORIGINAL RESPONSE"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUE SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H120887X
         -3 "-3 NO DATA IN ROUND"
         0 "0" ;

label define H120888X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 5 MIN"
         2 "2 5 TO 15 MINUTES"
         3 "3 16 TO 30 MINUTES"
         4 "4 31 TO 59 MINUTES"
         5 "5 1 TO 2 HOURS"
         6 "6 MORE THAN 2 HOURS" ;

label define H120889X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICUTLY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H120890X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120891X
         1 "1 ORIGINAL RESPONSE"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H120892X
         -3 "-3 NO DATA IN ROUND"
         0 "0" ;

label define H120893X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120894X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120895X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H120896X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK" ;

label define H120897X
         -3 "-3 NO DATA IN ROUND"
         0 "0" ;

label define H120898X
         -3 "-3 NO DATA IN ROUND"
         0 "0" ;

label define H120899X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120900X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120901X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120902X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H120903X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H120904X
         -1 "-1 INAPPLICABLE"
         0 "0" ;

label define H120905X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE OTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H120906X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE ANOTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H120907X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         1 "1 FAM/PERS CHNGD INS PLAN"
         10 "10 JOB RELATED REASON"
         11 "11 NEW DOC REF/RECOM"
         12 "12 OTH COMPLNT OLD DOC"
         13 "13 TRANSPORTATION"
         2 "2 INSUR PLAN CHNG DOCS"
         3 "3 DISSATIS W/QUAL CARE"
         4 "4 HEALTH CARE NEEDS CHNGD"
         5 "5 TOO FAR AWAY"
         6 "6 MOVED TO NEW AREA"
         7 "7 OLD PROV NOT AVAIL"
         8 "8 COST-RELATED REASON"
         9 "9 OTHER INSUR-RELATED REASON"
         91 "91 OTHER REASON" ;

label define H120908X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         1 "1 PREFERS/LIKES THIS USC"
         10 "10 INSURANCE RELATED REASON"
         2 "2 DK WHERE ELSE TO GO"
         3 "3 CANT AFFORD GO ELSEWHERE"
         4 "4 OWN DOC HAS OFFICE HERE"
         5 "5 ONLY CARE AVAIL WHEN TIME"
         6 "6 CONVENIENCE"
         7 "7 BEST FOR MY CONDITION"
         91 "91 OTHER REASON" ;

label define H120909X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         1 "1 FAM/PERS CHNGD INSUR PLAN"
         10 "10 OTH INSUR-RELATED REASON"
         3 "3 DISSATIS W/ QUAL CARE"
         5 "5 TOO FAR AWAY"
         6 "6 MOVED TO NEW AREA"
         7 "7 OLD PROV NOT AVAIL"
         8 "8 COST-RELATED REASON"
         9 "9 SELDOM SICK/NO NEED"
         91 "91 OTHER REASON" ;

label define H120910X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -8 "-8 DK"
         1 "1 SELDOM OR NEVER SICK"
         10 "10 OTHER INSUR-RELATED REAS"
         2 "2 RECENTLY MOVED TO AREA"
         3 "3 DONT KNOW WHERE TO GO"
         4 "4 USC IN AREA NOT AVAILABLE"
         5 "5 CANT FIND PROV SPEAK LANG"
         6 "6 GOES DIFF PL FOR DIFF NEEDS"
         7 "7 JUST CHANGED INSUR PLANS"
         8 "8 DONT USE DOCS/TREAT SELF"
         9 "9 COST OF MEDICAL CARE"
         91 "91 OTHER REASON" ;

label define H120911X
         0 "0"
         152 "152" ;

label define H120912X
         0 "0"
         2480 "2480"
         77 "77"
         8 "8" ;

label define H120913X
         0 "0"
         154 "154" ;

label define H120914X
         0 "0"
         152 "152"
         405 "405" ;

label define H120915X
         0 "0"
         131 "131"
         1461 "1461"
         1676 "1676"
         598 "598" ;

label define H120916X
         0 "0"
         1154 "1154" ;

label define H120917X
         0 "0"
         202 "202"
         45424 "45424" ;

label define H120918X
         0 "0"
         3 "3" ;

label define H120919X
         0 "0"
         1154 "1154" ;

* ASSOCIATE VARIABLES WITH VALUE LABEL DEFINITIONS;
label value ACCELIG2 H120001X;
label value ACTDUTY1 H120002X;
label value ACTDUTY2 H120003X;
label value ACTLIMT1 H120004X;
label value ACUPTH96 H120005X;
label value ACUPUN96 H120006X;
label value ADLHELP1 H120007X;
label value ADLHELP2 H120008X;
label value ADULPRO2 H120009X;
label value AFDC H120010X;
label value AFFORD2 H120011X;
label value AIDHELP1 H120012X;
label value ALCREE96 H120013X;
label value ALCREX96 H120014X;
label value ALCRSP96 H120015X;
label value ALCRVE96 H120016X;
label value ALCRVS96 H120017X;
label value ALIMIMP H120018X;
label value ALIMPNX H120019X;
label value ALTCAR96 H120020X;
label value ALTOTH96 H120021X;
label value ANYLIM12 H120022X;
label value ANYUSC2 H120023X;
label value APPDIFF2 H120024X;
label value APPTWLK2 H120025X;
label value AVAILTI2 H120026X;
label value BEGREFD1 H120027X;
label value BEGREFD2 H120028X;
label value BEGREFM1 H120029X;
label value BEGREFM2 H120030X;
label value BEGREFM3 H120031X;
label value BEGREFY1 H120032X;
label value BEGREFY2 H120033X;
label value BENDDIF1 H120034X;
label value BGNWK1 H120035X;
label value BGNWK2 H120036X;
label value BGNWK96 H120037X;
label value BIOFDB96 H120038X;
label value BIRTH96 H120039X;
label value BLDPCHK3 H120040X;
label value BLIND2 H120041X;
label value BRSTEXA3 H120042X;
label value BSNTY1 H120043X;
label value BSNTY2 H120044X;
label value BSNTY96 H120045X;
label value BSTPLAC2 H120046X;
label value BUSNIMP H120047X;
label value CANTPLA2 H120048X;
label value CANTSCH2 H120049X;
label value CARECOS2 H120050X;
label value CASHIMP H120051X;
label value CASHPNX H120052X;
label value CHAP96X H120053X;
label value CHAU96X H120054X;
label value CHDE96X H120055X;
label value CHFE96X H120056X;
label value CHIRO96 H120057X;
label value CHJA96X H120058X;
label value CHJL96X H120059X;
label value CHJU96X H120060X;
label value CHLDCAR2 H120061X;
label value CHLDIMP H120062X;
label value CHLDLIM2 H120063X;
label value CHLDPNX H120064X;
label value CHMA96X H120065X;
label value CHMPNOW1 H120066X;
label value CHMY96X H120067X;
label value CHNGJ12 H120068X;
label value CHNGJ231 H120069X;
label value CHNGUSC2 H120070X;
label value CHNO96X H120071X;
label value CHOC96X H120072X;
label value CHOIC1 H120073X;
label value CHOIC2 H120074X;
label value CHOIC96 H120075X;
label value CHOLCHK3 H120076X;
label value CHPEVER H120077X;
label value CHSE96X H120078X;
label value CIND1 H120079X;
label value CIND2 H120080X;
label value CIND96 H120081X;
label value CLAIMDEP H120082X;
label value CLERGY96 H120083X;
label value CLMHIP H120084X;
label value COCCP1 H120085X;
label value COCCP2 H120086X;
label value COCCP96 H120087X;
label value COGLIMT1 H120088X;
label value CONFIDN2 H120089X;
label value CONVENI2 H120090X;
label value DADPID1X H120091X;
label value DADPID2X H120092X;
label value DADPROB2 H120093X;
label value DDBEDYS1 H120094X;
label value DDBEDYS2 H120095X;
label value DDBEDYS3 H120096X;
label value DDNOWRK1 H120097X;
label value DDNOWRK2 H120098X;
label value DDNOWRK3 H120099X;
label value DDNSCHL1 H120100X;
label value DDNSCHL2 H120101X;
label value DDNSCHL3 H120102X;
label value DEAF2 H120103X;
label value DEDUCTNS H120104X;
label value DENTCHK3 H120105X;
label value DEPENDNT H120106X;
label value DEPINRU H120107X;
label value DEPOUTSD H120108X;
label value DIDSERVE H120109X;
label value DIFFPLA2 H120110X;
label value DISCAL96 H120111X;
label value DISTANC2 H120112X;
label value DISVW1X H120113X;
label value DISVW2X H120114X;
label value DISVW96X H120115X;
label value DIVDIMP H120116X;
label value DIVDPNX H120117X;
label value DKELSEW2 H120118X;
label value DKWHERG2 H120119X;
label value DKWHRUS2 H120120X;
label value DOBMM H120121X;
label value DTPSHOT2 H120122X;
label value DVGEN96 H120123X;
label value DVGWCP96 H120124X;
label value DVOMCR96 H120125X;
label value DVOOPU96 H120126X;
label value DVORTH96 H120127X;
label value DVOSTL96 H120128X;
label value DVTOT96 H120129X;
label value DVTWCP96 H120130X;
label value EDUCYR1 H120131X;
label value EDUCYR2 H120132X;
label value EDUCYR96 H120133X;
label value EICREDIT H120134X;
label value ELDISCR H120135X;
label value ELGRND96 H120136X;
label value ELIGRND1 H120137X;
label value ELIGRND2 H120138X;
label value EMPST1 H120139X;
label value EMPST2 H120140X;
label value EMPST96 H120141X;
label value ENDREFD1 H120142X;
label value ENDREFD2 H120143X;
label value ENDREFM1 H120144X;
label value ENDREFM2 H120145X;
label value ENDREFY1 H120146X;
label value ENDREFY2 H120147X;
label value ENDRFD96 H120148X;
label value ENDRFM96 H120149X;
label value ENDRFY96 H120150X;
label value ENDWK1 H120151X;
label value ENDWK2 H120152X;
label value ENDWK96 H120153X;
label value EQUIPMN2 H120154X;
label value ERDCHM96 H120155X;
label value ERDOFD96 H120156X;
label value ERDOSR96 H120157X;
label value ERDSTL96 H120158X;
label value ERFCHM96 H120159X;
label value ERFSTL96 H120160X;
label value ERTOT96 H120161X;
label value EVRET96 H120162X;
label value EVRWRK H120163X;
label value EXPENSI2 H120164X;
label value FAMCNS2 H120165X;
label value FAMRFPYR H120166X;
label value FAMSIZE2 H120167X;
label value FAMSZE96 H120168X;
label value FARMIMP H120169X;
label value FCRP1231 H120170X;
label value FILEDITR H120171X;
label value FILER H120172X;
label value FILESTAT H120173X;
label value FINGRDF1 H120174X;
label value FLUSHOT3 H120175X;
label value FMRS1231 H120176X;
label value FOODCOST H120177X;
label value FOODMNTH H120178X;
label value FOODSTMP H120179X;
label value FOODVALU H120180X;
label value FTSTU96X H120181X;
label value FTSTUD1X H120182X;
label value FTSTUD2X H120183X;
label value GETSICK2 H120184X;
label value GETTOUS2 H120185X;
label value HAVEFUN2 H120186X;
label value HAVEUSC2 H120187X;
label value HCNEEDS2 H120188X;
label value HEALTHY2 H120189X;
label value HEARAID2 H120190X;
label value HEARDIF2 H120191X;
label value HEARING2 H120192X;
label value HEARMOS2 H120193X;
label value HEARPRO2 H120194X;
label value HEARSOM2 H120195X;
label value HELD1X H120196X;
label value HELD2X H120197X;
label value HELD96X H120198X;
label value HEPBSHT2 H120199X;
label value HERBAL96 H120200X;
label value HERBTR96 H120201X;
label value HHACHM96 H120202X;
label value HHAGD96 H120203X;
label value HHAGM96 H120204X;
label value HHAOPU96 H120205X;
label value HHINDD96 H120206X;
label value HHINDM96 H120207X;
label value HHINFD96 H120208X;
label value HHINFM96 H120209X;
label value HHNMCR96 H120210X;
label value HHNOFD96 H120211X;
label value HHNSTL96 H120212X;
label value HHNVA96 H120213X;
label value HHTOTD96 H120214X;
label value HHTOTM96 H120215X;
label value HIDEG96 H120216X;
label value HIGHDEG1 H120217X;
label value HIGHDEG2 H120218X;
label value HIGHTFT2 H120219X;
label value HIGHTIN2 H120220X;
label value HISPANX H120221X;
label value HISPCAT H120222X;
label value HOMEBEH2 H120223X;
label value HOMEOM96 H120224X;
label value HOMEOT96 H120225X;
label value HOUR1 H120226X;
label value HOUR2 H120227X;
label value HOUR96 H120228X;
label value HPDAP96 H120229X;
label value HPDAU96 H120230X;
label value HPDDE96 H120231X;
label value HPDFE96 H120232X;
label value HPDJA96 H120233X;
label value HPDJL96 H120234X;
label value HPDJU96 H120235X;
label value HPDMA96 H120236X;
label value HPDMY96 H120237X;
label value HPDNO96 H120238X;
label value HPDOC96 H120239X;
label value HPDSE96 H120240X;
label value HPEAP96 H120241X;
label value HPEAU96 H120242X;
label value HPEDE96 H120243X;
label value HPEFE96 H120244X;
label value HPEJA96 H120245X;
label value HPEJL96 H120246X;
label value HPEJU96 H120247X;
label value HPEMA96 H120248X;
label value HPEMY96 H120249X;
label value HPENO96 H120250X;
label value HPEOC96 H120251X;
label value HPESE96 H120252X;
label value HPNAP96 H120253X;
label value HPNAU96 H120254X;
label value HPNDE96 H120255X;
label value HPNFE96 H120256X;
label value HPNJA96 H120257X;
label value HPNJL96 H120258X;
label value HPNJU96 H120259X;
label value HPNMA96 H120260X;
label value HPNMY96 H120261X;
label value HPNNO96 H120262X;
label value HPNOC96 H120263X;
label value HPNSE96 H120264X;
label value HPOAP96 H120265X;
label value HPOAU96 H120266X;
label value HPODE96 H120267X;
label value HPOFE96 H120268X;
label value HPOJA96 H120269X;
label value HPOJL96 H120270X;
label value HPOJU96 H120271X;
label value HPOMA96 H120272X;
label value HPOMY96 H120273X;
label value HPONO96 H120274X;
label value HPOOC96 H120275X;
label value HPOSE96 H120276X;
label value HPRAP96 H120277X;
label value HPRAU96 H120278X;
label value HPRDE96 H120279X;
label value HPRFE96 H120280X;
label value HPRIV1 H120281X;
label value HPRIVDK1 H120282X;
label value HPRIVEG1 H120283X;
label value HPRIVNG1 H120284X;
label value HPRIVOG1 H120285X;
label value HPRIVS1 H120286X;
label value HPRIVU1 H120287X;
label value HPRJA96 H120288X;
label value HPRJL96 H120289X;
label value HPRJU96 H120290X;
label value HPRMA96 H120291X;
label value HPRMY96 H120292X;
label value HPRNO96 H120293X;
label value HPROC96 H120294X;
label value HPRSE96 H120295X;
label value HPSAP96 H120296X;
label value HPSAU96 H120297X;
label value HPSDE96 H120298X;
label value HPSFE96 H120299X;
label value HPSJA96 H120300X;
label value HPSJL96 H120301X;
label value HPSJU96 H120302X;
label value HPSMA96 H120303X;
label value HPSMY96 H120304X;
label value HPSNO96 H120305X;
label value HPSOC96 H120306X;
label value HPSSE96 H120307X;
label value HRHOW1 H120308X;
label value HRHOW2 H120309X;
label value HRHOW96 H120310X;
label value HRWG1X H120311X;
label value HRWG2X H120312X;
label value HRWG96X H120313X;
label value HRWGIM1 H120314X;
label value HRWGIM2 H120315X;
label value HRWGIM96 H120316X;
label value HSELIG2 H120317X;
label value HSELIMT1 H120318X;
label value HYPNO96 H120319X;
label value IADLHLP1 H120320X;
label value IADLHLP2 H120321X;
label value INRU1231 H120322X;
label value INSALT96 H120323X;
label value INSAP96X H120324X;
label value INSAU96X H120325X;
label value INSC1231 H120326X;
label value INSCOP96 H120327X;
label value INSCOPE H120328X;
label value INSCOPE1 H120329X;
label value INSCOPE2 H120330X;
label value INSCOV96 H120331X;
label value INSDE96X H120332X;
label value INSFE96X H120333X;
label value INSIDE2 H120334X;
label value INSJA96X H120335X;
label value INSJL96X H120336X;
label value INSJU96X H120337X;
label value INSMA96X H120338X;
label value INSMY96X H120339X;
label value INSNO96X H120340X;
label value INSNOPA2 H120341X;
label value INSOC96X H120342X;
label value INSREAS2 H120343X;
label value INSRPLA2 H120344X;
label value INSRQRE2 H120345X;
label value INSSE96X H120346X;
label value INSURED1 H120347X;
label value INTOBLD2 H120348X;
label value INTRIMP H120349X;
label value INTRPNX H120350X;
label value INTRTAX H120351X;
label value IPDCHM96 H120352X;
label value IPDIS96 H120353X;
label value IPDOFD96 H120354X;
label value IPDOSR96 H120355X;
label value IPDSTL96 H120356X;
label value IPDVA96 H120357X;
label value IPFSTL96 H120358X;
label value IPFWCP96 H120359X;
label value IPNGTD96 H120360X;
label value IPZERO96 H120361X;
label value IRASIMP H120362X;
label value IRASPNX H120363X;
label value IRASTAX H120364X;
label value ITMEDEXP H120365X;
label value JNTINRU H120366X;
label value JOBORG1 H120367X;
label value JOBORG2 H120368X;
label value JOBORG96 H120369X;
label value JOINTPID H120370X;
label value KEYNESS H120371X;
label value KIDPROB2 H120372X;
label value LANGBAR2 H120373X;
label value LIFSKIL2 H120374X;
label value LIFTDIF1 H120375X;
label value LIKESUS2 H120376X;
label value LIMACT2 H120377X;
label value LIVEBIR1 H120378X;
label value LIVEBIR2 H120379X;
label value LIVEBIR3 H120380X;
label value LMOTACT2 H120381X;
label value LOCATIO2 H120382X;
label value LOSTEET3 H120383X;
label value MAINPRO2 H120384X;
label value MAMOGRM3 H120385X;
label value MARRY1X H120386X;
label value MARRY2X H120387X;
label value MARRY96X H120388X;
label value MASSAG96 H120389X;
label value MASSTH96 H120390X;
label value MCAID1 H120391X;
label value MCAID1X H120392X;
label value MCARNOW1 H120393X;
label value MCARNW1X H120394X;
label value MCDAP96 H120395X;
label value MCDAP96X H120396X;
label value MCDAU96 H120397X;
label value MCDAU96X H120398X;
label value MCDDE96 H120399X;
label value MCDDE96X H120400X;
label value MCDEVER H120401X;
label value MCDFE96 H120402X;
label value MCDFE96X H120403X;
label value MCDJA96 H120404X;
label value MCDJA96X H120405X;
label value MCDJL96 H120406X;
label value MCDJL96X H120407X;
label value MCDJU96 H120408X;
label value MCDJU96X H120409X;
label value MCDMA96 H120410X;
label value MCDMA96X H120411X;
label value MCDMY96 H120412X;
label value MCDMY96X H120413X;
label value MCDNO96 H120414X;
label value MCDNO96X H120415X;
label value MCDOC96 H120416X;
label value MCDOC96X H120417X;
label value MCDSE96 H120418X;
label value MCDSE96X H120419X;
label value MCRAP96 H120420X;
label value MCRAP96X H120421X;
label value MCRAU96 H120422X;
label value MCRAU96X H120423X;
label value MCRDE96 H120424X;
label value MCRDE96X H120425X;
label value MCREVER H120426X;
label value MCRFE96 H120427X;
label value MCRFE96X H120428X;
label value MCRHMO1 H120429X;
label value MCRJA96 H120430X;
label value MCRJA96X H120431X;
label value MCRJL96 H120432X;
label value MCRJL96X H120433X;
label value MCRJU96 H120434X;
label value MCRJU96X H120435X;
label value MCRMA96 H120436X;
label value MCRMA96X H120437X;
label value MCRMY96 H120438X;
label value MCRMY96X H120439X;
label value MCRNO96 H120440X;
label value MCRNO96X H120441X;
label value MCROC96 H120442X;
label value MCROC96X H120443X;
label value MCRSE96 H120444X;
label value MCRSE96X H120445X;
label value MDEXPAMT H120446X;
label value MDTREA96 H120447X;
label value MEDITA96 H120448X;
label value MILEDIF1 H120449X;
label value MINORPR2 H120450X;
label value MMRSHOT2 H120451X;
label value MNTHLTH1 H120452X;
label value MNTHLTH2 H120453X;
label value MNTPROX1 H120454X;
label value MNTPROX2 H120455X;
label value MOMPID1X H120456X;
label value MOMPID2X H120457X;
label value MOMPROB2 H120458X;
label value MORE1 H120459X;
label value MORE2 H120460X;
label value MORE96 H120461X;
label value MORJOB1 H120462X;
label value MORJOB2 H120463X;
label value MORJOB96 H120464X;
label value MSA3 H120465X;
label value MSA96 H120466X;
label value MYSELF2 H120467X;
label value NERVAFR2 H120468X;
label value NETMDDED H120469X;
label value NEWAREA2 H120470X;
label value NOAFFOR2 H120471X;
label value NOCARE2 H120472X;
label value NOOTHPR2 H120473X;
label value NOREAS42 H120474X;
label value NOREAS92 H120475X;
label value NOTIME2 H120476X;
label value NOWPREG1 H120477X;
label value NOWPREG2 H120478X;
label value NOWPREG3 H120479X;
label value NTHLTHY2 H120480X;
label value NUMDTP2 H120481X;
label value NUMEMP1 H120482X;
label value NUMEMP2 H120483X;
label value NUMEMP96 H120484X;
label value NUMPOLI2 H120485X;
label value NURTRT96 H120486X;
label value NUTRIT96 H120487X;
label value NWK1 H120488X;
label value NWK2 H120489X;
label value NWK96 H120490X;
label value OBACHM96 H120491X;
label value OBAOFD96 H120492X;
label value OBASST96 H120493X;
label value OBASTL96 H120494X;
label value OBAWCP96 H120495X;
label value OBCHIR96 H120496X;
label value OBCVA96 H120497X;
label value OBDRV96 H120498X;
label value OBEOFD96 H120499X;
label value OBEOPU96 H120500X;
label value OBESTL96 H120501X;
label value OBNURS96 H120502X;
label value OBOPTO96 H120503X;
label value OBOTHV96 H120504X;
label value OBTAINH2 H120505X;
label value OBTCHM96 H120506X;
label value OBTHER96 H120507X;
label value OBTOTV96 H120508X;
label value OBTSTL96 H120509X;
label value OCUPTHE2 H120510X;
label value OFFER1X H120511X;
label value OFFER2X H120512X;
label value OFFER96X H120513X;
label value OFFHOUR2 H120514X;
label value OFFICE2 H120515X;
label value OFFWORK2 H120516X;
label value OPAAP96 H120517X;
label value OPAAU96 H120518X;
label value OPADE96 H120519X;
label value OPAEVER H120520X;
label value OPAFE96 H120521X;
label value OPAJA96 H120522X;
label value OPAJL96 H120523X;
label value OPAJU96 H120524X;
label value OPAMA96 H120525X;
label value OPAMY96 H120526X;
label value OPANO96 H120527X;
label value OPAOC96 H120528X;
label value OPASE96 H120529X;
label value OPBAP96 H120530X;
label value OPBAU96 H120531X;
label value OPBDE96 H120532X;
label value OPBEVER H120533X;
label value OPBFE96 H120534X;
label value OPBJA96 H120535X;
label value OPBJL96 H120536X;
label value OPBJU96 H120537X;
label value OPBMA96 H120538X;
label value OPBMY96 H120539X;
label value OPBNO96 H120540X;
label value OPBOC96 H120541X;
label value OPBSE96 H120542X;
label value OPDCHM96 H120543X;
label value OPDOSR96 H120544X;
label value OPDRV96 H120545X;
label value OPDSTL96 H120546X;
label value OPOTHV96 H120547X;
label value OPPCHM96 H120548X;
label value OPPOPU96 H120549X;
label value OPPOSR96 H120550X;
label value OPPSTL96 H120551X;
label value OPSCHM96 H120552X;
label value OPSOFD96 H120553X;
label value OPSSTL96 H120554X;
label value OPTOTV96 H120555X;
label value OTGOVPY1 H120556X;
label value OTHALT96 H120557X;
label value OTHINSR2 H120558X;
label value OTHNMDD1 H120559X;
label value OTHNMDD2 H120560X;
label value OTHNMDD3 H120561X;
label value OTHOPU96 H120562X;
label value OTHOSR96 H120563X;
label value OTHRDYS1 H120564X;
label value OTHRDYS2 H120565X;
label value OTHRDYS3 H120566X;
label value OTHREA42 H120567X;
label value OTHREA92 H120568X;
label value OTHRIMP H120569X;
label value OTHRPNX H120570X;
label value OTHRPRO2 H120571X;
label value OTHSTL96 H120572X;
label value OTHSVC2 H120573X;
label value OTHWCP96 H120574X;
label value OTPUBA1 H120575X;
label value OTPUBB1 H120576X;
label value PALTEE96 H120577X;
label value PALTEX96 H120578X;
label value PAPSMER3 H120579X;
label value PAYDR1 H120580X;
label value PAYDR2 H120581X;
label value PAYDR96 H120582X;
label value PAYVAC1 H120583X;
label value PAYVAC2 H120584X;
label value PAYVAC96 H120585X;
label value PDKAP96 H120586X;
label value PDKAU96 H120587X;
label value PDKDE96 H120588X;
label value PDKFE96 H120589X;
label value PDKJA96 H120590X;
label value PDKJL96 H120591X;
label value PDKJU96 H120592X;
label value PDKMA96 H120593X;
label value PDKMY96 H120594X;
label value PDKNO96 H120595X;
label value PDKOC96 H120596X;
label value PDKSE96 H120597X;
label value PEGAP96 H120598X;
label value PEGAU96 H120599X;
label value PEGDE96 H120600X;
label value PEGFE96 H120601X;
label value PEGJA96 H120602X;
label value PEGJL96 H120603X;
label value PEGJU96 H120604X;
label value PEGMA96 H120605X;
label value PEGMY96 H120606X;
label value PEGNO96 H120607X;
label value PEGOC96 H120608X;
label value PEGSE96 H120609X;
label value PENSIMP H120610X;
label value PENSPNX H120611X;
label value PERCIN96 H120612X;
label value PERSLAN2 H120613X;
label value PHONEDI2 H120614X;
label value PHYSICL3 H120615X;
label value PHYTHER2 H120616X;
label value PLAYLIM2 H120617X;
label value PNGAP96 H120618X;
label value PNGAU96 H120619X;
label value PNGDE96 H120620X;
label value PNGFE96 H120621X;
label value PNGJA96 H120622X;
label value PNGJL96 H120623X;
label value PNGJU96 H120624X;
label value PNGMA96 H120625X;
label value PNGMY96 H120626X;
label value PNGNO96 H120627X;
label value PNGOC96 H120628X;
label value PNGSE96 H120629X;
label value POGAP96 H120630X;
label value POGAU96 H120631X;
label value POGDE96 H120632X;
label value POGFE96 H120633X;
label value POGJA96 H120634X;
label value POGJL96 H120635X;
label value POGJU96 H120636X;
label value POGMA96 H120637X;
label value POGMY96 H120638X;
label value POGNO96 H120639X;
label value POGOC96 H120640X;
label value POGSE96 H120641X;
label value POLIOSH2 H120642X;
label value POUAP96 H120643X;
label value POUAU96 H120644X;
label value POUDE96 H120645X;
label value POUFE96 H120646X;
label value POUJA96 H120647X;
label value POUJL96 H120648X;
label value POUJU96 H120649X;
label value POUMA96 H120650X;
label value POUMY96 H120651X;
label value POUNO96 H120652X;
label value POUOC96 H120653X;
label value POUSE96 H120654X;
label value POVCAT H120655X;
label value PREEXCO2 H120656X;
label value PREG96 H120657X;
label value PREGRD1 H120658X;
label value PREGRD2 H120659X;
label value PREGRD3 H120660X;
label value PREVENT2 H120661X;
label value PRGVPYA1 H120662X;
label value PRGVPYB1 H120663X;
label value PRIAP96 H120664X;
label value PRIAU96 H120665X;
label value PRIDE96 H120666X;
label value PRIFE96 H120667X;
label value PRIJA96 H120668X;
label value PRIJL96 H120669X;
label value PRIJU96 H120670X;
label value PRIMA96 H120671X;
label value PRIMY96 H120672X;
label value PRINO96 H120673X;
label value PRIOC96 H120674X;
label value PRISE96 H120675X;
label value PRIV1 H120676X;
label value PRIVDK1 H120677X;
label value PRIVEG1 H120678X;
label value PRIVNG1 H120679X;
label value PRIVOG1 H120680X;
label value PRIVOUT1 H120681X;
label value PRIVS1 H120682X;
label value PRIVU1 H120683X;
label value PRLISTE2 H120684X;
label value PROGTXT2 H120685X;
label value PROSEXA3 H120686X;
label value PROVSTA2 H120687X;
label value PROVTYX2 H120688X;
label value PROXY1 H120689X;
label value PROXY2 H120690X;
label value PROXY96 H120691X;
label value PRSAP96 H120692X;
label value PRSAU96 H120693X;
label value PRSDE96 H120694X;
label value PRSFE96 H120695X;
label value PRSJA96 H120696X;
label value PRSJL96 H120697X;
label value PRSJU96 H120698X;
label value PRSMA96 H120699X;
label value PRSMY96 H120700X;
label value PRSNO96 H120701X;
label value PRSOC96 H120702X;
label value PRSSE96 H120703X;
label value PRVEVER H120704X;
label value PSTATUS1 H120705X;
label value PSTATUS2 H120706X;
label value PSTATUS3 H120707X;
label value PSYCNSL2 H120708X;
label value PUBAP96X H120709X;
label value PUBAU96X H120710X;
label value PUBDE96X H120711X;
label value PUBFE96X H120712X;
label value PUBIMP H120713X;
label value PUBJA96X H120714X;
label value PUBJL96X H120715X;
label value PUBJU96X H120716X;
label value PUBLIC1 H120717X;
label value PUBMA96X H120718X;
label value PUBMY96X H120719X;
label value PUBNO96X H120720X;
label value PUBOC96X H120721X;
label value PUBPNX H120722X;
label value PUBSE96X H120723X;
label value PUBTRAN2 H120724X;
label value RACETHNX H120725X;
label value RACEX H120726X;
label value READINT2 H120727X;
label value READNEW2 H120728X;
label value RECHDIF1 H120729X;
label value RECPEOP2 H120730X;
label value RECTHER2 H120731X;
label value REFDIMP H120732X;
label value REFDPNX H120733X;
label value REFFRLS2 H120734X;
label value REFREL1X H120735X;
label value REFREL2X H120736X;
label value REFRMD96 H120737X;
label value REFUSER2 H120738X;
label value REFUSIN2 H120739X;
label value REGION1 H120740X;
label value REGION2 H120741X;
label value REGION3 H120742X;
label value REGION96 H120743X;
label value RESP1 H120744X;
label value RESP2 H120745X;
label value RESP96 H120746X;
label value RETPLN1 H120747X;
label value RETPLN2 H120748X;
label value RETPLN96 H120749X;
label value RFREL96X H120750X;
label value RTEHLTH1 H120751X;
label value RTEHLTH2 H120752X;
label value RTEPROX1 H120753X;
label value RTEPROX2 H120754X;
label value RUCLAS96 H120755X;
label value RUCLASS1 H120756X;
label value RUCLASS2 H120757X;
label value RXCHM96 H120758X;
label value RXEXP96 H120759X;
label value RXMCD96 H120760X;
label value RXMCR96 H120761X;
label value RXOFD96 H120762X;
label value RXOPR96 H120763X;
label value RXOPU96 H120764X;
label value RXOSR96 H120765X;
label value RXPRV96 H120766X;
label value RXSLF96 H120767X;
label value RXSTL96 H120768X;
label value RXTOT96 H120769X;
label value RXVA96 H120770X;
label value RXWCP96 H120771X;
label value SALEIMP H120772X;
label value SCHLBEH2 H120773X;
label value SCHLIMT1 H120774X;
label value SCHLPRO2 H120775X;
label value SCLINBD1 H120776X;
label value SCLINBD2 H120777X;
label value SCLINBD3 H120778X;
label value SEEDIF2 H120779X;
label value SELDSIC2 H120780X;
label value SELFCM1 H120781X;
label value SELFCM2 H120782X;
label value SELFCM96 H120783X;
label value SEX H120784X;
label value SHFTWK1 H120785X;
label value SHFTWK2 H120786X;
label value SHFTWK96 H120787X;
label value SIBPROB2 H120788X;
label value SICPAY1 H120789X;
label value SICPAY2 H120790X;
label value SICPAY96 H120791X;
label value SOCLIMT1 H120792X;
label value SPCHTHE2 H120793X;
label value SPECED2 H120794X;
label value SPECIFL2 H120795X;
label value SPECPRO2 H120796X;
label value SPECSCH2 H120797X;
label value SPIRTU96 H120798X;
label value SPORPRO2 H120799X;
label value SPOUID96 H120800X;
label value SPOUIN96 H120801X;
label value SPOUSID1 H120802X;
label value SPOUSID2 H120803X;
label value SPOUSIN1 H120804X;
label value SPOUSIN2 H120805X;
label value SSECIMP H120806X;
label value SSECPNX H120807X;
label value SSECTAX H120808X;
label value SSIDISAB H120809X;
label value SSIIMP H120810X;
label value SSIPNX H120811X;
label value STAAP96 H120812X;
label value STAAU96 H120813X;
label value STADE96 H120814X;
label value STAFE96 H120815X;
label value STAJA96 H120816X;
label value STAJL96 H120817X;
label value STAJU96 H120818X;
label value STAMA96 H120819X;
label value STAMY96 H120820X;
label value STANO96 H120821X;
label value STAOC96 H120822X;
label value STASE96 H120823X;
label value STATPRG1 H120824X;
label value STEPDIF1 H120825X;
label value STJBDD1 H120826X;
label value STJBDD2 H120827X;
label value STJBDD96 H120828X;
label value STJBMM1 H120829X;
label value STJBMM2 H120830X;
label value STJBMM96 H120831X;
label value STJBYY1 H120832X;
label value STJBYY2 H120833X;
label value STJBYY96 H120834X;
label value STNDDIF1 H120835X;
label value TAXFORM H120836X;
label value TOTCHM96 H120837X;
label value TOTDED H120838X;
label value TOTEXP96 H120839X;
label value TOTMCD96 H120840X;
label value TOTMCR96 H120841X;
label value TOTOFD96 H120842X;
label value TOTOPR96 H120843X;
label value TOTOPU96 H120844X;
label value TOTOSR96 H120845X;
label value TOTPRV96 H120846X;
label value TOTSLF96 H120847X;
label value TOTSTL96 H120848X;
label value TOTVA96 H120849X;
label value TOTWCP96 H120850X;
label value TRADIT96 H120851X;
label value TREATMN2 H120852X;
label value TROUBLE2 H120853X;
label value TRSTIMP H120854X;
label value TUTOR2 H120855X;
label value TYPEPER2 H120856X;
label value TYPEPLC2 H120857X;
label value UNABLE1 H120858X;
label value UNEMIMP H120859X;
label value UNEMPNX H120860X;
label value UNEMTAX H120861X;
label value UNHAP2 H120862X;
label value UNINSURD H120863X;
label value UNION1 H120864X;
label value UNION2 H120865X;
label value UNION96 H120866X;
label value UPRHMO1 H120867X;
label value UPRMNC1 H120868X;
label value UPUBHMO1 H120869X;
label value UPUBMNC1 H120870X;
label value USCNOTA2 H120871X;
label value USCQUAL2 H120872X;
label value VARPSU2 H120873X;
label value VARSTRT2 H120874X;
label value VETKOR H120875X;
label value VETOTH H120876X;
label value VETPVIET H120877X;
label value VETSIMP H120878X;
label value VETSPNX H120879X;
label value VETVIET H120880X;
label value VETWW H120881X;
label value VISCHM96 H120882X;
label value VISION2 H120883X;
label value VISOPU96 H120884X;
label value VOCSVCS2 H120885X;
label value WAGEIMP H120886X;
label value WAGEPNX H120887X;
label value WAITTIM2 H120888X;
label value WALKDIF1 H120889X;
label value WALKLIM1 H120890X;
label value WCMPIMP H120891X;
label value WCMPPNX H120892X;
label value WEARDEN3 H120893X;
label value WEARGLA2 H120894X;
label value WEIGHLB2 H120895X;
label value WEIGHOZ2 H120896X;
label value WGTRU2T H120897X;
label value WGTSP2T H120898X;
label value WILLFILE H120899X;
label value WRKINBD1 H120900X;
label value WRKINBD2 H120901X;
label value WRKINBD3 H120902X;
label value WRKLIMT1 H120903X;
label value WTDPER96 H120904X;
label value YCHJB12 H120905X;
label value YCHJB231 H120906X;
label value YCHNGUS2 H120907X;
label value YGOTOUS2 H120908X;
label value YNOMORE2 H120909X;
label value YNOUSC2 H120910X;
label value ZIDOFD96 H120911X;
label value ZIDOPR96 H120912X;
label value ZIDOPU96 H120913X;
label value ZIDVA96 H120914X;
label value ZIDWCP96 H120915X;
label value ZIFOFD96 H120916X;
label value ZIFOPR96 H120917X;
label value ZIFOPU96 H120918X;
label value ZIFVA96 H120919X;

*DISPLAY A DESCRIPTION OF STATA FILE;
describe;

*LIST FIRST 20 OBSERVATIONS IN THE FILE;
list in 1/20;


#delimit cr


/************************************************************************************************
 NOTES:                                                                                          
                                                                                                 
 1. This program has been tested on Stata Version 10 (for Windows).                              
                                                                                                 
 2. This program will create a permanent Stata dataset.  All additional analyses                 
    can be run using this dataset.  In addition to the dataset, this program creates             
    a log file named H12.LOG and a data file named H12.DTA.  If these files (H12.DTA and H12.LOG)
    already exist in the working directory, they will be replaced when this program is executed. 
                                                                                                 
 3. If the program ends prematurely, the log file will remain open.  Before running this         
    program again, the user should enter the following Stata command: log close                  
                                                                                                 
 4. The cd command assigns C:\MEPS\DATA as the working directory and location of the input       
    ASCII and output .DTA and .LOG files and can be modified by the user as necessary.           
                                                                                                 
 5. Stata commands end with a carriage return by default. The command                            
    #delimit ;                                                                                   
    temporarily changes the command ending delimiter from a carriage return to a semicolon.      
                                                                                                 
 6. The infix command assumes that the input variables are numeric unless the variable name      
    is prefaced by str.  For example, DUPERSID is the a string (or character) variable.          
                                                                                                 
************************************************************************************************/

